/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.TreeMapToList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class KnownspellsToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;

    @Override
    public String getTokenName() {
        return "KNOWNSPELLS";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer pipeTok = new StringTokenizer(value, "|");
        boolean firstToken = true;
        while (pipeTok.hasMoreTokens()) {
            String totalFilter = pipeTok.nextToken();
            if (".CLEARALL".equals(totalFilter)) {
                if (!firstToken) {
                    return new ParseResult.Fail("Non-sensical situation was encountered while parsing " + this.getTokenName() + ": When used, .CLEARALL must be the first argument", context);
                }
                context.getObjectContext().removeList(pcc, ListKey.KNOWN_SPELLS);
                continue;
            }
            ParseResult pr = this.checkForIllegalSeparator(',', totalFilter);
            if (!pr.passed()) {
                return pr;
            }
            StringTokenizer commaTok = new StringTokenizer(totalFilter, ",");
            Integer levelLim = null;
            CDOMReference sp = null;
            while (commaTok.hasMoreTokens()) {
                block13: {
                    String filterString = commaTok.nextToken();
                    if (filterString.startsWith("LEVEL=")) {
                        if (levelLim != null) {
                            return new ParseResult.Fail("Cannot have more than one Level limit in " + this.getTokenName() + ": " + value, context);
                        }
                        try {
                            levelLim = Integer.valueOf(filterString.substring(6));
                            if (levelLim < 0) {
                                ComplexParseResult cpr = new ComplexParseResult();
                                cpr.addErrorMessage("Invalid Number in " + this.getTokenName() + ": " + value);
                                cpr.addErrorMessage("  Level must be >= 0");
                                return cpr;
                            }
                            break block13;
                        }
                        catch (NumberFormatException e) {
                            ComplexParseResult cpr = new ComplexParseResult();
                            cpr.addErrorMessage("Invalid Number in " + this.getTokenName() + ": " + value);
                            cpr.addErrorMessage("  Level must be a non-negative integer");
                            return cpr;
                        }
                    }
                    if (sp != null) {
                        return new ParseResult.Fail("Cannot have more than one Type/Spell limit in " + this.getTokenName() + ": " + value, context);
                    }
                    sp = TokenUtilities.getTypeOrPrimitive(context, SPELL_CLASS, filterString);
                    if (sp == null) {
                        return new ParseResult.Fail("  encountered Invalid limit in " + this.getTokenName() + ": " + value, context);
                    }
                }
                firstToken = false;
            }
            if (sp == null) {
                sp = context.getReferenceContext().getCDOMAllReference(SPELL_CLASS);
            }
            KnownSpellIdentifier ksi = new KnownSpellIdentifier(sp, levelLim);
            context.getObjectContext().addToList(pcc, ListKey.KNOWN_SPELLS, ksi);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        Collection<KnownSpellIdentifier> removedItems;
        Changes<KnownSpellIdentifier> changes = context.getObjectContext().getListChanges(pcc, ListKey.KNOWN_SPELLS);
        ArrayList<String> list = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            list.add(".CLEARALL");
        }
        if ((removedItems = changes.getRemoved()) != null && !removedItems.isEmpty()) {
            context.addWriteMessage(this.getTokenName() + " does not support .CLEAR.");
            return null;
        }
        Collection<KnownSpellIdentifier> added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            TreeMapToList map = new TreeMapToList(ReferenceUtilities.REFERENCE_SORTER);
            for (KnownSpellIdentifier ksi : added) {
                CDOMReference<Spell> ref = ksi.getSpellReference();
                Integer i = ksi.getSpellLevel();
                map.addToListFor(ref, (Object)i);
            }
            for (CDOMReference ref : map.getKeySet()) {
                for (Integer lvl : map.getListFor((Object)ref)) {
                    StringBuilder sb = new StringBuilder();
                    boolean needComma = false;
                    String refString = ref.getLSTformat(false);
                    if (!"ALL".equals(refString)) {
                        sb.append(refString);
                        needComma = true;
                    }
                    if (lvl != null) {
                        if (needComma) {
                            sb.append(',');
                        }
                        sb.append("LEVEL=").append(lvl);
                    }
                    list.add(sb.toString());
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(list, (String)"|")};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

