/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcreteTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.choiceset.SpellReferenceChoiceSet;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.PCClass;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SpelllistToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<ClassSpellList> SPELLLIST_CLASS = ClassSpellList.class;
    private static final Class<DomainSpellList> DOMAINSPELLLIST_CLASS = DomainSpellList.class;

    @Override
    public String getTokenName() {
        return "SPELLLIST";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        Formula count = FormulaFactory.getFormulaFor(tok.nextToken());
        if (!count.isValid()) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
        }
        if (!count.isStatic() || count.resolveStatic().intValue() <= 0) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " must be > 0", context);
        }
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " must have a | separating " + "count from the list of possible values: " + value, context);
        }
        ArrayList<CDOMReference<? extends CDOMListObject<Spell>>> refs = new ArrayList<CDOMReference<? extends CDOMListObject<Spell>>>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            CDOMReference ref = "ALL".equals(token) ? context.getReferenceContext().getCDOMAllReference(SPELLLIST_CLASS) : (token.startsWith("DOMAIN.") ? context.getReferenceContext().getCDOMReference(DOMAINSPELLLIST_CLASS, token.substring(7)) : context.getReferenceContext().getCDOMReference(SPELLLIST_CLASS, token));
            refs.add(ref);
        }
        SpellReferenceChoiceSet rcs = new SpellReferenceChoiceSet(refs);
        if (!rcs.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        ChoiceSet<CDOMListObject<Spell>> cs = new ChoiceSet<CDOMListObject<Spell>>(this.getTokenName(), rcs);
        cs.setTitle("Select class whose list of spells this class will use");
        ConcreteTransitionChoice<CDOMListObject<Spell>> tc = new ConcreteTransitionChoice<CDOMListObject<Spell>>(cs, count);
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.SPELLLIST_CHOICE, tc);
        tc.setRequired(false);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        TransitionChoice<CDOMListObject<Spell>> grantChanges = context.getObjectContext().getObject(pcc, ObjectKey.SPELLLIST_CHOICE);
        if (grantChanges == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Formula count = grantChanges.getCount();
        if (count == null) {
            context.addWriteMessage("Unable to find " + this.getTokenName() + " Count");
            return null;
        }
        sb.append(count);
        sb.append("|");
        sb.append(grantChanges.getChoices().getLSTformat().replaceAll(",", "|"));
        return new String[]{sb.toString()};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

