/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass.level;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Skill;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CskillToken
extends AbstractTokenWithSeparator<PCClassLevel>
implements CDOMPrimaryToken<PCClassLevel> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    @Override
    public String getTokenName() {
        return "CSKILL";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClassLevel obj, String value) {
        boolean first = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item", context);
                }
                context.getObjectContext().removeList(obj, ListKey.LOCALCSKILL);
            } else if (tokText.startsWith(".CLEAR.")) {
                String clearText = tokText.substring(7);
                if ("ALL".equals(clearText)) {
                    context.getObjectContext().removeFromList(obj, ListKey.LOCALCSKILL, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
                } else {
                    CDOMReference<Skill> ref = TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, clearText);
                    if (ref == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                    context.getObjectContext().removeFromList(obj, ListKey.LOCALCSKILL, ref);
                }
            } else if ("ALL".equals(tokText)) {
                foundAny = true;
                context.getObjectContext().addToList(obj, ListKey.LOCALCSKILL, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
            } else {
                foundOther = true;
                CDOMReference<Skill> ref = this.getSkillReference(context, tokText);
                if (ref == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                }
                context.getObjectContext().addToList(obj, ListKey.LOCALCSKILL, ref);
            }
            first = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference<Skill>(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, tokText);
    }

    @Override
    public String[] unparse(LoadContext context, PCClassLevel obj) {
        Collection<CDOMReference<Skill>> added;
        Changes<CDOMReference<Skill>> changes = context.getObjectContext().getListChanges(obj, ListKey.LOCALCSKILL);
        ArrayList<String> list = new ArrayList<String>();
        Collection<CDOMReference<Skill>> removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat(removedItems, "|.CLEAR."));
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((added = changes.getAdded()) != null && !added.isEmpty()) {
            list.add(ReferenceUtilities.joinLstFormat(added, "|"));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }
}

