/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.core.Race;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class RacesubtypeToken
extends AbstractTokenWithSeparator<Race>
implements CDOMPrimaryToken<Race> {
    @Override
    public String getTokenName() {
        return "RACESUBTYPE";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Race race, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        boolean first = true;
        while (tok.hasMoreTokens()) {
            String tokString = tok.nextToken();
            if (".CLEAR".equals(tokString)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + value, context);
                }
                context.getObjectContext().removeList(race, ListKey.RACESUBTYPE);
            } else if (tokString.startsWith(".CLEAR.")) {
                String clearText = tokString.substring(7);
                context.getObjectContext().removeFromList(race, ListKey.RACESUBTYPE, RaceSubType.getConstant(clearText));
            } else {
                context.getObjectContext().addToList(race, ListKey.RACESUBTYPE, RaceSubType.getConstant(tokString));
            }
            first = false;
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Race race) {
        Changes<RaceSubType> changes = context.getObjectContext().getListChanges(race, ListKey.RACESUBTYPE);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collection<RaceSubType> removedItems = changes.getRemoved();
        if (changes.includesGlobalClear()) {
            if (removedItems != null && !removedItems.isEmpty()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR");
        } else if (removedItems != null && !removedItems.isEmpty()) {
            list.add(".CLEAR." + StringUtil.join(removedItems, (String)"|.CLEAR."));
        }
        Collection<RaceSubType> added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            list.add(StringUtil.join(added, (String)"|"));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

