/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.skill;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCStat;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class KeystatToken
extends AbstractNonEmptyToken<Skill>
implements CDOMPrimaryToken<Skill> {
    private static final Class<PCStat> PCSTAT_CLASS = PCStat.class;

    @Override
    public String getTokenName() {
        return "KEYSTAT";
    }

    @Override
    public ParseResult parseNonEmptyToken(LoadContext context, Skill skill, String value) {
        CDOMSingleRef<PCStat> pcs = context.getReferenceContext().getCDOMReference(PCSTAT_CLASS, value);
        if (pcs == null) {
            return new ParseResult.Fail("Invalid Stat Abbreviation in Token " + this.getTokenName() + ": " + value, context);
        }
        context.getObjectContext().put((CDOMObject)skill, ObjectKey.KEY_STAT, pcs);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Skill skill) {
        CDOMSingleRef<PCStat> pcs = context.getObjectContext().getObject(skill, ObjectKey.KEY_STAT);
        if (pcs == null) {
            return null;
        }
        return new String[]{pcs.getLSTformat(false)};
    }

    @Override
    public Class<Skill> getTokenClass() {
        return Skill.class;
    }
}

