/*
 * Decompiled with CFR 0.152.
 */
package plugin.network.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import pcgen.system.LanguageBundle;

public class NetworkView
extends JPanel {
    private static final long serialVersionUID = 4984238484753403840L;
    private static final String DEFAULT_IP = "0.0.0.0";
    private ButtonGroup buttonGroup1;
    private JPanel clientPanel;
    private JButton connectButton;
    private JPanel connectedUsersPanel;
    private JPanel connectionPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTabbedPane logPane;
    private JTextField messageBox;
    private JButton messageButton;
    private JPanel messagePanel;
    private JLabel noteText;
    private JLabel noteTitle;
    private JRadioButton rbClient;
    private JRadioButton rbServer;
    private JTextField serverAddress;
    private JToolBar toolbar;
    private JList userList;

    public NetworkView() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.toolbar = new JToolBar();
        this.rbServer = new JRadioButton();
        this.rbClient = new JRadioButton();
        this.clientPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.serverAddress = new JTextField(15);
        this.connectButton = new JButton();
        this.connectionPanel = new JPanel();
        this.noteTitle = new JLabel();
        this.noteText = new JLabel();
        this.logPane = new JTabbedPane();
        this.messagePanel = new JPanel();
        this.messageBox = new JTextField();
        this.messageButton = new JButton();
        this.connectedUsersPanel = new JPanel();
        this.userList = new JList();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.rbServer.setText(LanguageBundle.getString("in_plugin_network_server"));
        this.buttonGroup1.add(this.rbServer);
        this.toolbar.add(this.rbServer);
        this.rbClient.setText(LanguageBundle.getString("in_plugin_network_client"));
        this.buttonGroup1.add(this.rbClient);
        this.toolbar.add(this.rbClient);
        this.toolbar.addSeparator();
        this.clientPanel.setLayout(new FlowLayout(1, 5, 3));
        this.jLabel2.setText(LanguageBundle.getString("in_plugin_network_serverAddr"));
        this.toolbar.add(this.jLabel2);
        this.serverAddress.setText(DEFAULT_IP);
        this.clientPanel.add(this.serverAddress);
        this.connectButton.setText(LanguageBundle.getString("in_plugin_network_connect"));
        this.connectButton.setMargin(new Insets(0, 10, 0, 10));
        this.clientPanel.add(this.connectButton);
        this.toolbar.add(this.clientPanel);
        this.toolbar.addSeparator();
        this.connectionPanel.setLayout(new FlowLayout(1, 5, 6));
        this.connectionPanel.add(this.noteTitle);
        this.connectionPanel.add(this.noteText);
        this.toolbar.add(this.connectionPanel);
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.logPane, "Center");
        this.messagePanel.setLayout(new BorderLayout());
        this.messagePanel.add((Component)this.messageBox, "Center");
        this.messageButton.setText(LanguageBundle.getString("in_plugin_network_sendMsg"));
        this.messagePanel.add((Component)this.messageButton, "East");
        this.add((Component)this.messagePanel, "South");
        this.connectedUsersPanel.setLayout(new BorderLayout());
        this.connectedUsersPanel.setBorder(new EtchedBorder());
        this.userList.setBorder(new EtchedBorder());
        this.userList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Broadcast"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.userList.setSelectionMode(0);
        this.connectedUsersPanel.add((Component)this.userList, "Center");
        this.jLabel1.setText(LanguageBundle.getString("in_plugin_network_spaced"));
        this.connectedUsersPanel.add((Component)this.jLabel1, "North");
        this.add((Component)this.connectedUsersPanel, "East");
    }

    public JTabbedPane getLogPane() {
        return this.logPane;
    }

    public JTextField getServerAddressTextField() {
        return this.serverAddress;
    }

    public JButton getConnectButton() {
        return this.connectButton;
    }

    public JRadioButton getServerRadioButton() {
        return this.rbServer;
    }

    public JRadioButton getClientRadioButton() {
        return this.rbClient;
    }

    public JButton getMessageButton() {
        return this.messageButton;
    }

    public JTextField getMessageTextField() {
        return this.messageBox;
    }

    public JList getUserList() {
        return this.userList;
    }

    public void setLocalAddressText(String address) {
        this.jLabel2.setText(LanguageBundle.getString("in_plugin_network_localAddr") + address);
    }

    public void setConnectionText(String title, String text) {
        this.noteTitle.setText(LanguageBundle.getFormattedString("in_plugin_network_connectiontext", title));
        this.noteText.setText(text);
    }

    public void hideClientPanel() {
        this.clientPanel.setVisible(false);
    }

    public void showClientPanel() {
        this.jLabel2.setText(LanguageBundle.getString("in_plugin_network_serverAddr"));
        this.clientPanel.setVisible(true);
    }

    public void hideConnectionPanel() {
        this.connectionPanel.setVisible(false);
    }

    public void showConnectionPanel() {
        this.connectionPanel.setVisible(true);
    }
}

