/*
 * Decompiled with CFR 0.152.
 */
package plugin.overland;

import gmgen.GMGenSystemView;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.Utility;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.system.LanguageBundle;
import plugin.overland.gui.OverPanel;

public class OverlandPlugin
implements InteractivePlugin {
    public static final String LOG_NAME = "Overland_Travel";
    private JMenuItem overToolsItem = new JMenuItem();
    private OverPanel theView;
    private static final String NAME = "Overland Travel";
    private static final String IN_NAME = "in_plugin_overland_name";
    private static final String IN_NAME_MN = "in_mn_plugin_overland_name";
    private String version = "01.00.99.01.00";
    private PCGenMessageHandler messageHandler;

    @Override
    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        File datadir = this.getDataDirectory();
        this.theView = new OverPanel(datadir);
        this.messageHandler.handleMessage(new RequestAddTabToGMGenMessage(this, this.getLocalizedName(), this.getView()));
        this.initMenus();
    }

    @Override
    public void stop() {
        this.messageHandler = null;
    }

    @Override
    public int getPriority() {
        return SettingsHandler.getGMGenOption("Overland_Travel.LoadOrder", 90);
    }

    @Override
    public String getPluginName() {
        return NAME;
    }

    private String getLocalizedName() {
        return LanguageBundle.getString(IN_NAME);
    }

    public Component getView() {
        return this.theView;
    }

    @Override
    public void handleMessage(PCGenMessage message) {
        if (message instanceof FocusOrStateChangeOccurredMessage) {
            if (this.isActive()) {
                this.overToolsItem.setEnabled(false);
            } else {
                this.overToolsItem.setEnabled(true);
            }
        }
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor(this.theView);
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.theView);
    }

    public void initMenus() {
        this.overToolsItem.setMnemonic(LanguageBundle.getMnemonic(IN_NAME_MN));
        this.overToolsItem.setText(this.getLocalizedName());
        this.overToolsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverlandPlugin.this.toolMenuItem(evt);
            }
        });
        this.messageHandler.handleMessage(new AddMenuItemToGMGenToolsMenuMessage(this, this.overToolsItem));
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!(tp.getComponentAt(i) instanceof OverPanel)) continue;
            tp.setSelectedIndex(i);
        }
    }

    @Override
    public File getDataDirectory() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }
}

