/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreLanguageTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        String requiredLang = prereq.getKey();
        int requiredNumber = Integer.parseInt(prereq.getOperand());
        int runningTotal = 0;
        if (prereq.getKey().equalsIgnoreCase("ANY")) {
            runningTotal = display.getLanguageCount();
        } else {
            Language aLang = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Language.class, requiredLang);
            if (aLang != null) {
                if (display.hasLanguage(aLang)) {
                    runningTotal = 1;
                }
            } else if (!requiredLang.equals("ANY")) {
                throw new PrerequisiteException(LanguageBundle.getFormattedString("PreLanguage.error.no_such_language", requiredLang));
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, requiredNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "LANG";
    }
}

