/*
 * Decompiled with CFR 0.152.
 */
package plugin.qualifier.skill;

import java.util.Collection;
import java.util.logging.Level;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.converter.AddFilterConverter;
import pcgen.cdom.converter.NegateFilterConverter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.util.Logging;

public class RanksToken
implements QualifierToken<Skill>,
PrimitiveFilter<Skill> {
    private static final String MAXRANK = "MAXRANK";
    private PrimitiveCollection<Skill> pcs = null;
    private boolean wasRestricted = false;
    private boolean negated = false;
    private int ranks;
    private boolean maxRank = false;

    @Override
    public String getTokenName() {
        return "RANKS";
    }

    @Override
    public Class<Skill> getReferenceClass() {
        return Skill.class;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        StringBuilder sb = new StringBuilder();
        if (this.negated) {
            sb.append('!');
        }
        sb.append(this.getTokenName());
        sb.append('=');
        if (this.maxRank) {
            sb.append(MAXRANK);
        } else {
            sb.append(this.ranks);
        }
        if (this.wasRestricted) {
            sb.append('[').append(this.pcs.getLSTformat(useAny)).append(']');
        }
        return sb.toString();
    }

    @Override
    public boolean initialize(LoadContext context, SelectionCreator<Skill> sc, String condition, String value, boolean negate) {
        if (condition == null) {
            Logging.addParseMessage(Level.SEVERE, this.getTokenName() + " Must be a conditional Qualifier, e.g. " + this.getTokenName() + "=10");
            return false;
        }
        try {
            this.ranks = Integer.parseInt(condition);
        }
        catch (NumberFormatException e) {
            if (MAXRANK.equalsIgnoreCase(condition)) {
                this.maxRank = true;
            }
            Logging.addParseMessage(Level.SEVERE, this.getTokenName() + " Must be a numerical conditional Qualifier, e.g. " + this.getTokenName() + "=10 ... Offending value: " + condition);
            return false;
        }
        this.negated = negate;
        if (value == null) {
            this.pcs = sc.getAllReference();
        } else {
            this.pcs = context.getPrimitiveChoiceFilter(sc, value);
            this.wasRestricted = true;
        }
        return this.pcs != null;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState gs = this.pcs == null ? GroupingState.ANY : this.pcs.getGroupingState().reduce();
        return this.negated ? gs.negate() : gs;
    }

    public int hashCode() {
        return this.pcs == null ? 0 : this.pcs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RanksToken) {
            RanksToken other = (RanksToken)o;
            if (this.negated == other.negated && this.ranks == other.ranks && this.maxRank == other.maxRank) {
                if (this.pcs == null) {
                    return other.pcs == null;
                }
                return this.pcs.equals(other.pcs);
            }
        }
        return false;
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Skill, R> c) {
        AddFilterConverter<Skill, R> conv = new AddFilterConverter<Skill, R>(c, this);
        conv = this.negated ? new NegateFilterConverter<Skill, R>(conv) : conv;
        return this.pcs.getCollection(pc, conv);
    }

    @Override
    public boolean allow(PlayerCharacter pc, Skill sk) {
        float pcRanks = pc.getDisplay().getRank(sk).floatValue();
        if (this.maxRank) {
            double maxRanks = pc.getMaxRank(sk, pc.getClassList().get(0)).doubleValue();
            return maxRanks <= (double)pcRanks;
        }
        return (float)this.ranks <= pcRanks;
    }
}

