/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import gmgen.plugin.PcgCombatant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import plugin.initiative.gui.TableColumnInformation;

public class OpposedSkillBasicModel
extends AbstractTableModel {
    protected TableColumnInformation columns = new TableColumnInformation(10);
    protected TreeMap combatants = new TreeMap();

    public OpposedSkillBasicModel() {
        this.columns.addColumn("COMBATANT", String.class, null, false, "Combatant");
    }

    public OpposedSkillBasicModel(List combatantList) {
        this();
        this.buildCombatantList(combatantList);
    }

    protected void buildCombatantList(List combatantList) {
        for (Object o : combatantList) {
            if (o == null || !(o instanceof PcgCombatant)) continue;
            PcgCombatant cbt = (PcgCombatant)o;
            this.addCombatant(cbt);
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.columns.getClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.columns.getColumCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.getLabel(column);
    }

    @Override
    public int getRowCount() {
        return Math.max(this.combatants.size(), 1);
    }

    protected InitWrapper getRowEntry(int rowIndex) {
        InitWrapper returnValue = null;
        if (rowIndex < this.combatants.size()) {
            returnValue = (InitWrapper)((Map.Entry)this.combatants.entrySet().toArray()[rowIndex]).getValue();
        }
        return returnValue;
    }

    protected int getIndexOf(String name) {
        int returnValue = -1;
        int counter = -1;
        Iterator i = this.combatants.keySet().iterator();
        while (i.hasNext() && returnValue < 0) {
            ++counter;
            if (!i.next().equals(name)) continue;
            returnValue = counter;
        }
        return returnValue;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String returnValue = null;
        if (rowIndex < this.combatants.size()) {
            InitWrapper entry = this.getRowEntry(rowIndex);
            switch (columnIndex) {
                case 0: {
                    returnValue = entry.initiative.getName();
                }
            }
        }
        return returnValue;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean returnValue = false;
        if (rowIndex < this.getRowCount()) {
            returnValue = this.columns.isColumnEditable(columnIndex);
        }
        return returnValue;
    }

    public void addCombatant(PcgCombatant combatant) {
        this.combatants.put(combatant.getName(), new InitWrapper(combatant));
        int rowIndex = this.getIndexOf(combatant.getName());
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void removeCombatant(int rowIndex) {
        if (rowIndex < this.combatants.size()) {
            InitWrapper entry = this.getRowEntry(rowIndex);
            this.combatants.remove(entry.initiative.getName());
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    public void removeCombatant(String name) {
        int rowIndex = this.getIndexOf(name);
        this.combatants.remove(name);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public PcgCombatant getCombatant(int rowIndex) {
        PcgCombatant returnValue = null;
        if (rowIndex < this.combatants.size()) {
            returnValue = this.getRowEntry((int)rowIndex).initiative;
        }
        return returnValue;
    }

    protected class InitWrapper {
        PcgCombatant initiative = null;

        public InitWrapper(PcgCombatant init) {
            this.initiative = init;
        }
    }
}

