/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lobobrowser.html.domimpl.AttrImpl;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
extends AbstractScriptableDelegate
implements NamedNodeMap {
    private final Map attributes = new HashMap();
    private final ArrayList attributeList = new ArrayList();

    public NamedNodeMapImpl(Element owner, Map attribs) {
        Iterator i = attribs.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            AttrImpl attr = new AttrImpl(name, value, true, owner, "ID".equals(name));
            this.attributes.put(name, attr);
            this.attributeList.add(attr);
        }
    }

    public int getLength() {
        return this.attributeList.size();
    }

    public Node getNamedItem(String name) {
        return (Node)this.attributes.get(name);
    }

    public Node namedItem(String name) {
        return this.getNamedItem(name);
    }

    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "No namespace support");
    }

    public Node item(int index) {
        try {
            return (Node)this.attributeList.get(index);
        }
        catch (IndexOutOfBoundsException iob) {
            return null;
        }
    }

    public Node removeNamedItem(String name) throws DOMException {
        return (Node)this.attributes.remove(name);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "No namespace support");
    }

    public Node setNamedItem(Node arg) throws DOMException {
        Node prevValue = this.attributes.put(arg.getNodeName(), arg);
        if (prevValue != null) {
            this.attributeList.remove(prevValue);
        }
        this.attributeList.add(arg);
        return arg;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new DOMException(9, "No namespace support");
    }
}

