/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils.typedarrays;

import com.eclipsesource.v8.utils.typedarrays.ArrayBuffer;
import com.eclipsesource.v8.utils.typedarrays.TypedArray;
import java.nio.ByteBuffer;

public class Float32Array
extends TypedArray {
    public Float32Array(ByteBuffer buffer) {
        super(buffer);
    }

    public Float32Array(ArrayBuffer arrayBuffer) {
        this(arrayBuffer.getByteBuffer());
    }

    public float get(int index) {
        return this.buffer.asFloatBuffer().get(index);
    }

    @Override
    public int length() {
        return this.buffer.asFloatBuffer().limit();
    }

    public void put(int index, float value) {
        this.buffer.asFloatBuffer().put(index, value);
    }

    @Override
    public int getType() {
        return 16;
    }
}

