/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractJsGraphvizEngine;
import guru.nidi.graphviz.engine.GraalJavascriptEngine;
import guru.nidi.graphviz.engine.GraphvizLoader;
import guru.nidi.graphviz.engine.JavascriptEngine;
import guru.nidi.graphviz.engine.MissingDependencyException;
import guru.nidi.graphviz.engine.NashornJavascriptEngine;
import javax.annotation.Nullable;

public class GraphvizJdkEngine
extends AbstractJsGraphvizEngine {
    static final boolean AVAILABLE = AbstractJsGraphvizEngine.AVAILABLE && (GraphvizJdkEngine.tryGraal() != null || GraphvizLoader.isOnClasspath("net/arnx/nashorn/lib/PromiseException.class"));

    public GraphvizJdkEngine() {
        super(false, GraphvizJdkEngine::newEngine);
        if (!AVAILABLE) {
            throw new MissingDependencyException("JDK engine is not available.", "net.arnx:nashorn-promise");
        }
    }

    private static JavascriptEngine newEngine() {
        GraalJavascriptEngine graal = GraphvizJdkEngine.tryGraal();
        return graal == null ? new NashornJavascriptEngine() : graal;
    }

    @Nullable
    private static GraalJavascriptEngine tryGraal() {
        try {
            return new GraalJavascriptEngine();
        }
        catch (ExceptionInInitializerError | IllegalStateException | NoClassDefFoundError e) {
            return null;
        }
    }

    @Override
    protected void doInit() {
        JavascriptEngine engine = this.engine();
        if (engine instanceof NashornJavascriptEngine) {
            engine.executeJavascript(this.promiseJsCode());
        }
        super.doInit();
    }
}

