/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import mill.api.KeyedLockedCache;
import mill.moduledefs.Scaladoc;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@Scaladoc(value="/**\n * Simple fixed size cache mainly intended for use in [[ZincWorkerImpl]] with the following properties\n * - Elements are lazily initialized upon first access\n * - Cached element ordering is preserved. The earliest available cache entry which is probably a compiler instance\n *   will always be returned first, and it will always be put back in the cache in the same position.\n *   This is important because each compiler instance is JITed independently. So with a stable ordering\n *   so we can bias towards reusing an already warm compiler.\n *\n * @param perKeySize Cache Size per unique key\n */")
@ScalaSignature(bytes="\u0006\u0005M4AAB\u0004\u0001\u0019!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\r)\u0003\u0001\u0015!\u0003.\u0011\u0015Y\u0005\u0001\"\u0011M\u000551\u0015\u000e_*ju\u0016$7)Y2iK*\u0011\u0001\"C\u0001\u0004CBL'\"\u0001\u0006\u0002\t5LG\u000e\\\u0002\u0001+\ti!dE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007cA\u000b\u001715\tq!\u0003\u0002\u0018\u000f\t\u00012*Z=fI2{7m[3e\u0007\u0006\u001c\u0007.\u001a\t\u00033ia\u0001\u0001B\u0003\u001c\u0001\t\u0007ADA\u0001U#\ti\u0002\u0005\u0005\u0002\u0010=%\u0011q\u0004\u0005\u0002\b\u001d>$\b.\u001b8h!\ty\u0011%\u0003\u0002#!\t\u0019\u0011I\\=\u0002\u0015A,'oS3z'&TX\r\u0005\u0002\u0010K%\u0011a\u0005\u0005\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002*UA\u0019Q\u0003\u0001\r\t\u000b\r\u0012\u0001\u0019\u0001\u0013\u0002\u0015-,\u0017\u0010V8DC\u000eDW-F\u0001.!\u0011qSg\u000e\u001e\u000e\u0003=R!\u0001M\u0019\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00023g\u0005!Q\u000f^5m\u0015\u0005!\u0014\u0001\u00026bm\u0006L!AN\u0018\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002\u0010q%\u0011\u0011\b\u0005\u0002\u0005\u0019>tw\r\u0005\u0003\u0010wu\u0002\u0015B\u0001\u001f\u0011\u0005\u0019!V\u000f\u001d7feA\u0011aFP\u0005\u0003\u007f=\u0012\u0011bU3nCBDwN]3\u0011\u0007=\t5)\u0003\u0002C!\t)\u0011I\u001d:bsB!qb\u000f#H!\tyQ)\u0003\u0002G!\t9!i\\8mK\u0006t\u0007cA\bI1%\u0011\u0011\n\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017-,\u0017\u0010V8DC\u000eDW\rI\u0001\u0010o&$\bnQ1dQ\u0016$g+\u00197vKV\u0011Q*\u0015\u000b\u0003\u001dv#\"a\u0014-\u0015\u0005A\u001b\u0006CA\rR\t\u0015\u0011VA1\u0001\u001d\u0005\u00051\u0006\"\u0002+\u0006\u0001\u0004)\u0016A\u000143!\u0011ya\u000b\u0007)\n\u0005]\u0003\"!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0019IV\u0001\"a\u00015\u0006\ta\rE\u0002\u00107bI!\u0001\u0018\t\u0003\u0011q\u0012\u0017P\\1nKzBQAX\u0003A\u0002]\n1a[3zQ\u0011\u0001\u0001MZ4\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rL\u0011AC7pIVdW\rZ3gg&\u0011QM\u0019\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\n\u0001.\u0001CX_)R#\u0002\t\u0016!'&l\u0007\u000f\\3!M&DX\r\u001a\u0011tSj,\u0007eY1dQ\u0016\u0004S.Y5oYf\u0004\u0013N\u001c;f]\u0012,G\r\t4pe\u0002*8/\u001a\u0011j]\u0002Z6LW5oG^{'o[3s\u00136\u0004H.X/!o&$\b\u000e\t;iK\u00022w\u000e\u001c7po&tw\r\t9s_B,'\u000f^5fg*\u0001#\u0006I\u0017!\u000b2,W.\u001a8ug\u0002\n'/\u001a\u0011mCjLG.\u001f\u0011j]&$\u0018.\u00197ju\u0016$\u0007%\u001e9p]\u00022\u0017N]:uA\u0005\u001c7-Z:t\u0015\u0001R\u0003%\f\u0011DC\u000eDW\r\u001a\u0011fY\u0016lWM\u001c;!_J$WM]5oO\u0002J7\u000f\t9sKN,'O^3e]\u0001\"\u0006.\u001a\u0011fCJd\u0017.Z:uA\u00054\u0018-\u001b7bE2,\u0007eY1dQ\u0016\u0004SM\u001c;ss\u0002:\b.[2iA%\u001c\b\u0005\u001d:pE\u0006\u0014G.\u001f\u0011bA\r|W\u000e]5mKJ\u0004\u0013N\\:uC:\u001cWM\u0003\u0011+A\u0001\u0002s/\u001b7mA\u0005dw/Y=tA\t,\u0007E]3ukJtW\r\u001a\u0011gSJ\u001cH\u000f\f\u0011b]\u0012\u0004\u0013\u000e\u001e\u0011xS2d\u0007%\u00197xCf\u001c\bEY3!aV$\bEY1dW\u0002Jg\u000e\t;iK\u0002\u001a\u0017m\u00195fA%t\u0007\u0005\u001e5fAM\fW.\u001a\u0011q_NLG/[8o])\u0001#\u0006\t\u0011!)\"L7\u000fI5tA%l\u0007o\u001c:uC:$\bEY3dCV\u001cX\rI3bG\"\u00043m\\7qS2,'\u000fI5ogR\fgnY3!SN\u0004#*\u0013+fI\u0002Jg\u000eZ3qK:$WM\u001c;ms:\u00023k\u001c\u0011xSRD\u0007%\u0019\u0011ti\u0006\u0014G.\u001a\u0011pe\u0012,'/\u001b8h\u0015\u0001R\u0003\u0005\t\u0011t_\u0002:X\rI2b]\u0002\u0012\u0017.Y:!i><\u0018M\u001d3tAI,Wo]5oO\u0002\ng\u000eI1me\u0016\fG-\u001f\u0011xCJl\u0007eY8na&dWM\u001d\u0018\u000bA)R\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011qKJ\\U-_*ju\u0016\u00043)Y2iK\u0002\u001a\u0016N_3!a\u0016\u0014\b%\u001e8jcV,\u0007e[3z\u0015\u0001Rs\u0006\u000b\u0004\u0001U6t\u0007/\u001d\t\u0003\u001f-L!\u0001\u001c\t\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0003=\f!%V:fA5LG\u000e\u001c\u0018ba&t3)Y2iK\u00124\u0015m\u0019;pef\u0004\u0013N\\:uK\u0006$\u0017!B:j]\u000e,\u0017%\u0001:\u0002#5KG\u000e\u001c\u0011tS:\u001cW\r\t\u0019/cIr3\u0007")
public class FixSizedCache<T>
implements KeyedLockedCache<T> {
    private final int perKeySize;
    private final ConcurrentHashMap<Object, Tuple2<Semaphore, Tuple2<Object, Option<T>>[]>> keyToCache;

    private ConcurrentHashMap<Object, Tuple2<Semaphore, Tuple2<Object, Option<T>>[]>> keyToCache() {
        return this.keyToCache;
    }

    @Override
    public <V> V withCachedValue(long key2, Function0<T> f, Function1<T, V> f2) {
        Tuple2<Semaphore, Tuple2<Object, Option<T>>[]> cacheEntry = this.keyToCache().get(BoxesRunTime.boxToLong(key2));
        if (cacheEntry == null) {
            Semaphore newSemaphore = new Semaphore(this.perKeySize, true);
            Tuple2[] newCache = (Tuple2[])Array$.MODULE$.fill(this.perKeySize, (Function0<Tuple2> & Serializable)() -> new Tuple2<Boolean, None$>(BoxesRunTime.boxToBoolean(false), None$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class));
            this.keyToCache().putIfAbsent(BoxesRunTime.boxToLong(key2), new Tuple2<Semaphore, Tuple2[]>(newSemaphore, newCache));
            cacheEntry = this.keyToCache().get(BoxesRunTime.boxToLong(key2));
        }
        Semaphore perKeySemaphore = cacheEntry._1();
        Tuple2<Object, Option<T>>[] perKeyCache = cacheEntry._2();
        perKeySemaphore.acquire();
        Tuple2<Object, Option<T>>[] tuple2Array = perKeyCache;
        synchronized (perKeyCache) {
            V v;
            T t;
            Object qual$1 = Predef$.MODULE$.refArrayOps(perKeyCache);
            Function1<Tuple2, Object> & Serializable x$1 = (Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(FixSizedCache.$anonfun$withCachedValue$2(x0$1));
            int x$2 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$1);
            int usableCompilerSlot = ArrayOps$.MODULE$.indexWhere$extension(qual$1, x$1, x$2);
            Predef$.MODULE$.require(usableCompilerSlot >= 0, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(59).append("Invariant violated: usableCompilerSlot must be >= 0. Found ").append(usableCompilerSlot).toString());
            Tuple2<Object, Option<T>> tuple2 = perKeyCache[usableCompilerSlot];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean inUse = tuple2._1$mcZ$sp();
            Option<T> compilerOpt = tuple2._2();
            Tuple2<Boolean, Option<T>> tuple22 = new Tuple2<Boolean, Option<T>>(BoxesRunTime.boxToBoolean(inUse), compilerOpt);
            boolean inUse2 = tuple22._1$mcZ$sp();
            Option<T> compilerOpt2 = tuple22._2();
            Predef$.MODULE$.require(!inUse2, (Function0<Object>)(Function0<String> & Serializable)() -> "Invariant violated: Compiler must not be in use");
            perKeyCache[usableCompilerSlot] = new Tuple2<Boolean, Option<T>>(BoxesRunTime.boxToBoolean(true), compilerOpt2);
            Tuple2<Integer, Option<T>> tuple23 = new Tuple2<Integer, Option<T>>(BoxesRunTime.boxToInteger(usableCompilerSlot), compilerOpt2);
            // ** MonitorExit[var14_9] (shouldn't be in output)
            Tuple2<Integer, Option<T>> tuple24 = tuple23;
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            int usableCompilerSlot2 = tuple24._1$mcI$sp();
            Option<T> compilerOpt3 = tuple24._2();
            Tuple2<Integer, Option<T>> tuple25 = new Tuple2<Integer, Option<T>>(BoxesRunTime.boxToInteger(usableCompilerSlot2), compilerOpt3);
            int usableCompilerSlot3 = tuple25._1$mcI$sp();
            Option<T> compilerOpt4 = tuple25._2();
            try {
                t = compilerOpt4.getOrElse(f);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                throw package$.MODULE$.exit(1);
            }
            T compiler = t;
            try {
                v = f2.apply(compiler);
            }
            catch (Throwable throwable) {
                Tuple2<Object, Option<T>>[] tuple2Array2 = perKeyCache;
                synchronized (perKeyCache) {
                    perKeyCache[usableCompilerSlot3] = new Tuple2<Boolean, Some<T>>(BoxesRunTime.boxToBoolean(false), new Some<T>(compiler));
                    // ** MonitorExit[var34_30] (shouldn't be in output)
                    perKeySemaphore.release();
                    throw throwable;
                }
            }
            Tuple2<Object, Option<T>>[] tuple2Array3 = perKeyCache;
            synchronized (perKeyCache) {
                perKeyCache[usableCompilerSlot3] = new Tuple2<Boolean, Some<T>>(BoxesRunTime.boxToBoolean(false), new Some<T>(compiler));
                // ** MonitorExit[var35_31] (shouldn't be in output)
                perKeySemaphore.release();
                V result2 = v;
                return result2;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$withCachedValue$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            boolean compilerInUse = tuple2._1$mcZ$sp();
            return !compilerInUse;
        }
        throw new MatchError(tuple2);
    }

    public FixSizedCache(int perKeySize) {
        this.perKeySize = perKeySize;
        this.keyToCache = new ConcurrentHashMap();
    }
}

