/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream.input;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import uk.org.webcompere.systemstubs.stream.input.AltInputStream;
import uk.org.webcompere.systemstubs.stream.input.DecoratingAltStream;

public class ThrowAtEndStream
extends DecoratingAltStream {
    private IOException ioException;
    private RuntimeException runtimeException;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ThrowAtEndStream(AltInputStream decoratee, IOException ioException) {
        super(decoratee);
        this.ioException = Objects.requireNonNull(ioException);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ThrowAtEndStream(AltInputStream decoratee, RuntimeException runtimeException) {
        super(decoratee);
        this.runtimeException = Objects.requireNonNull(runtimeException);
    }

    @Override
    public int read() throws IOException {
        int next = super.read();
        if (next == -1) {
            this.throwException();
        }
        return next;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0 || len > buffer.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.readNextLine(buffer, offset, len);
    }

    private int readNextLine(byte[] buffer, int offset, int len) throws IOException {
        byte[] lineSeparator = System.lineSeparator().getBytes(Charset.defaultCharset());
        int writeLocation = offset;
        while (writeLocation - offset < len) {
            int next = this.read();
            if (next == -1) {
                return writeLocation == offset ? -1 : writeLocation - offset;
            }
            buffer[writeLocation] = (byte)(next & 0xFF);
            if (!this.reachedLineEnd(buffer, offset, ++writeLocation, lineSeparator)) continue;
            break;
        }
        return writeLocation - offset;
    }

    private boolean reachedLineEnd(byte[] buffer, int bufferStart, int bufferEnd, byte[] lineSeparator) {
        if (bufferEnd - bufferStart < lineSeparator.length) {
            return false;
        }
        for (int i = 0; i < lineSeparator.length; ++i) {
            if (buffer[bufferEnd - lineSeparator.length + i] == lineSeparator[i]) continue;
            return false;
        }
        return true;
    }

    private void throwException() throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        throw this.runtimeException;
    }
}

