/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.stream.Stream;
import uk.org.webcompere.systemstubs.stream.output.Output;

public class MultiplexOutput
extends OutputStream
implements Output<MultiplexOutput> {
    private Output<?>[] outputs;

    public MultiplexOutput(Output<?> first, Output<?> ... others) {
        this.outputs = (Output[])Stream.concat(Stream.of(first), Arrays.stream(others)).toArray(Output[]::new);
    }

    @Override
    public void write(int b) throws IOException {
        for (Output<?> output : this.outputs) {
            ((OutputStream)output.getOutputStream()).write(b);
        }
    }

    @Override
    public String getText() {
        return this.outputs[0].getText();
    }

    @Override
    public void clear() {
        for (Output<?> output : this.outputs) {
            output.clear();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeOutput();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void closeOutput() throws Exception {
        for (Output<?> output : this.outputs) {
            output.closeOutput();
        }
    }

    @Override
    public MultiplexOutput getOutputStream() {
        return this;
    }
}

