/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.internal.AutoCloseableLock;

public final class KeyAwareAutoCloseableLock {
    private final Map<Object, AutoCloseableLock> internalMap = new ConcurrentHashMap<Object, AutoCloseableLock>();

    public AutoReleasable lockForObject(Object key) {
        AutoCloseableLock internal = this.internalMap.computeIfAbsent(Objects.requireNonNull(key), k -> new AutoCloseableLock());
        return new AutoReleasable(internal.lock(), () -> this.internalMap.remove(key));
    }

    public static class AutoReleasable
    implements AutoCloseable {
        private final AutoCloseableLock lock;
        private final Runnable cleanupAction;

        AutoReleasable(AutoCloseableLock lock, Runnable cleanupAction) {
            this.lock = Objects.requireNonNull(lock);
            this.cleanupAction = this.lock.isHeldByCurrentThread() ? () -> {} : Objects.requireNonNull(cleanupAction);
        }

        @Override
        public void close() {
            this.lock.close();
            this.cleanupAction.run();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AutoReleasable that = (AutoReleasable)object;
            return Objects.equals(this.lock, that.lock);
        }

        public int hashCode() {
            return Objects.hash(this.lock);
        }
    }
}

