/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.io.PrintStream;
import jlibs.core.lang.OS;

public class Ansi {
    public static final boolean SUPPORTED = Boolean.getBoolean("Ansi") || OS.get().isUnix() && System.console() != null;
    private static final String PREFIX = "\u001b[";
    private static final String SUFFIX = "m";
    private static final String SEPARATOR = ";";
    private static final String END = "\u001b[m";
    private String start = "";

    public Ansi(Attribute attr, Color foreground, Color background) {
        this.init(attr, foreground, background);
    }

    public Ansi(String format) {
        String[] tokens = format.split(SEPARATOR);
        Attribute attribute = null;
        try {
            if (tokens.length > 0 && tokens[0].length() > 0) {
                attribute = Attribute.valueOf(tokens[0]);
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        Color foreground = null;
        try {
            if (tokens.length > 1 && tokens[1].length() > 0) {
                foreground = Color.valueOf(tokens[1]);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        Color background = null;
        try {
            if (tokens.length > 2 && tokens[2].length() > 0) {
                background = Color.valueOf(tokens[2]);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.init(attribute, foreground, background);
    }

    private void init(Attribute attr, Color foreground, Color background) {
        StringBuilder buff = new StringBuilder();
        if (attr != null) {
            buff.append((Object)attr);
        }
        if (foreground != null) {
            if (buff.length() > 0) {
                buff.append(SEPARATOR);
            }
            buff.append(30 + foreground.ordinal());
        }
        if (background != null) {
            if (buff.length() > 0) {
                buff.append(SEPARATOR);
            }
            buff.append(40 + background.ordinal());
        }
        buff.insert(0, PREFIX);
        buff.append(SUFFIX);
        this.start = buff.toString();
    }

    public String toString() {
        int end;
        Enum attr = null;
        Enum foreground = null;
        Color background = null;
        block0: for (String token : this.start.substring(PREFIX.length(), this.start.length() - SUFFIX.length()).split(SEPARATOR)) {
            int i = Integer.parseInt(token);
            if (i < 30) {
                for (Attribute value : Attribute.values()) {
                    if (!value.toString().equals(token)) continue;
                    attr = value;
                    continue block0;
                }
                continue;
            }
            if (i < 40) {
                foreground = Color.values()[i - 30];
                continue;
            }
            background = Color.values()[i - 40];
        }
        StringBuilder buff = new StringBuilder();
        if (attr != null) {
            buff.append(attr.name());
        }
        buff.append(';');
        if (foreground != null) {
            buff.append(foreground.name());
        }
        buff.append(';');
        if (background != null) {
            buff.append(background.name());
        }
        for (end = buff.length() - 1; end >= 0 && buff.charAt(end) == ';'; --end) {
        }
        return buff.substring(0, end + 1);
    }

    public String colorize(String message) {
        if (SUPPORTED) {
            StringBuilder buff = new StringBuilder(this.start.length() + message.length() + END.length());
            buff.append(this.start).append(message).append(END);
            return buff.toString();
        }
        return message;
    }

    public void print(PrintStream ps, String message) {
        if (SUPPORTED) {
            ps.print(this.start);
        }
        ps.print(message);
        if (SUPPORTED) {
            ps.print(END);
        }
    }

    public void println(PrintStream ps, String message) {
        this.print(ps, message);
        ps.println();
    }

    public void format(PrintStream ps, String format, Object ... args) {
        if (SUPPORTED) {
            ps.print(this.start);
        }
        ps.format(format, args);
        if (SUPPORTED) {
            ps.print(END);
        }
    }

    public void out(String message) {
        this.print(System.out, message);
    }

    public void outln(String message) {
        this.println(System.out, message);
    }

    public void outFormat(String format, Object ... args) {
        this.format(System.out, format, args);
    }

    public void err(String message) {
        this.print(System.err, message);
    }

    public void errln(String message) {
        this.print(System.err, message);
    }

    public void errFormat(String format, Object ... args) {
        this.format(System.err, format, args);
    }

    public static enum Color {
        BLACK,
        RED,
        GREEN,
        YELLOW,
        BLUE,
        MAGENTA,
        CYAN,
        WHITE;

    }

    public static enum Attribute {
        NORMAL(0),
        BRIGHT(1),
        DIM(2),
        UNDERLINE(4),
        BLINK(5),
        REVERSE(7),
        HIDDEN(8);

        private String value;

        private Attribute(int value) {
            this.value = String.valueOf(value);
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

