/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import jlibs.core.lang.ImpossibleException;

public enum OS {
    WINDOWS_NT("Windows NT"),
    WINDOWS_95("Windows 95"),
    WINDOWS_98("Windows 98"),
    WINDOWS_2000("Windows 2000"),
    WINDOWS_VISTA("Windows Vista"),
    WINDOWS_7("Windows 7"),
    WINDOWS_OTHER("Windows"),
    SOLARIS("Solaris"),
    LINUX("Linux"),
    HP_UX("HP-UX"),
    IBM_AIX("AIX"),
    SGI_IRIX("Irix"),
    SUN_OS("SunOS"),
    COMPAQ_TRU64_UNIX("Digital UNIX"),
    MAC("Mac OS X", "Darwin"),
    FREEBSD("freebsd"),
    OS2("OS/2"),
    COMPAQ_OPEN_VMS("OpenVMS"),
    OTHER("");

    private String[] names;
    private static OS current;

    private OS(String ... names) {
        this.names = names;
    }

    public boolean isWindows() {
        return this.ordinal() <= WINDOWS_OTHER.ordinal();
    }

    public boolean isUnix() {
        return this.ordinal() > WINDOWS_OTHER.ordinal() && this.ordinal() < OS2.ordinal();
    }

    public static OS get(String osName) {
        osName = osName.toLowerCase();
        for (OS os : OS.values()) {
            for (String name : os.names) {
                if (!osName.contains(name.toLowerCase())) continue;
                return os;
            }
        }
        throw new ImpossibleException();
    }

    public static OS get() {
        if (current == null) {
            current = OS.get(System.getProperty("os.name"));
        }
        return current;
    }
}

