/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.net;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import jlibs.core.io.FileUtil;
import jlibs.core.io.IOUtil;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.lang.StringUtil;
import jlibs.core.net.SSLUtil;

public class URLUtil {
    private static SSLContext sc;

    public static URI toURI(String str) {
        return URI.create(str);
    }

    public static URI toURI(URL url) {
        return URI.create(url.toString());
    }

    public static URL toURL(String systemID) {
        if (StringUtil.isWhitespace(systemID)) {
            return null;
        }
        systemID = systemID.trim();
        try {
            return new URL(systemID);
        }
        catch (MalformedURLException ex) {
            return FileUtil.toURL(new File(systemID));
        }
    }

    public static String toSystemID(URL url) {
        try {
            if ("file".equals(url.getProtocol())) {
                return new File(url.toURI()).getAbsolutePath();
            }
            return url.toString();
        }
        catch (URISyntaxException ex) {
            throw new ImpossibleException(ex);
        }
    }

    public static URI resolve(String base, String child) {
        URI childURI = URI.create(child);
        if (childURI.isAbsolute()) {
            return childURI;
        }
        if (base == null) {
            base = new File("temp.txt").getAbsolutePath();
        }
        return URLUtil.toURI(URLUtil.toURL(base)).resolve(childURI);
    }

    public static URI relativize(String base, String child) {
        int slash;
        if (base == null) {
            base = new File("temp.txt").getAbsolutePath();
        }
        if ((slash = base.lastIndexOf(47)) != -1) {
            base = base.substring(0, slash + 1);
        }
        return URLUtil.toURI(URLUtil.toURL(base)).relativize(URI.create(child));
    }

    public static Map<String, String> getQueryParams(String uri, String encoding) throws URISyntaxException, UnsupportedEncodingException {
        if (encoding == null) {
            encoding = IOUtil.UTF_8.name();
        }
        String query = new URI(uri).getRawQuery();
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer params = new StringTokenizer(query, "&;");
        while (params.hasMoreTokens()) {
            String param = params.nextToken();
            int equal = param.indexOf(61);
            String name = param.substring(0, equal);
            String value = param.substring(equal + 1);
            name = URLDecoder.decode(name, encoding);
            value = URLDecoder.decode(value, encoding);
            map.put(name, value);
        }
        return map;
    }

    public static String suggestFile(URI uri, String extension) {
        String path = uri.getPath();
        String[] tokens = StringUtil.getTokens(path, "/", true);
        String file = tokens[tokens.length - 1];
        int dot = file.indexOf(".");
        if (dot == -1) {
            return file + '.' + extension;
        }
        return file.substring(0, dot + 1) + extension;
    }

    public static String suggestPrefix(Properties suggested, String uri) {
        return suggested.getProperty(uri, "ns");
    }

    public static URLConnection createUnCertifiedConnection(URL url, Proxy proxy) throws IOException {
        URLConnection con;
        if (sc == null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, SSLUtil.DUMMY_TRUST_MANAGERS, new SecureRandom());
                URLUtil.sc = sc;
            }
            catch (Exception ex) {
                throw new ImpossibleException(ex);
            }
        }
        URLConnection uRLConnection = con = proxy == null ? url.openConnection() : url.openConnection(proxy);
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection httpsCon = (HttpsURLConnection)con;
            httpsCon.setSSLSocketFactory(sc.getSocketFactory());
            httpsCon.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            });
        }
        return con;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(URLUtil.getQueryParams("http://www.google.co.in/search?hl=en&client=firefox-a&rls=org.mozilla%3Aen-US%3Aofficial&hs=Jvw&q=java%26url+encode&btnG=Search&meta=&aq=f&oq=", null));
        System.out.println(URLUtil.suggestPrefix(new Properties(), "urn:xxx:yyy"));
    }
}

