/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ExpandDetails;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.file.Chmod;

public class NormalizingCopyActionDecorator
implements CopyAction {
    private final CopyAction delegate;
    private final Chmod chmod;

    public NormalizingCopyActionDecorator(CopyAction delegate, Chmod chmod) {
        this.delegate = delegate;
        this.chmod = chmod;
    }

    @Override
    public WorkResult execute(CopyActionProcessingStream stream) {
        HashSet visitedDirs = new HashSet();
        ArrayListMultimap pendingDirs = ArrayListMultimap.create();
        return this.delegate.execute(arg_0 -> this.lambda$execute$1(stream, visitedDirs, (ListMultimap)pendingDirs, arg_0));
    }

    private void maybeVisit(RelativePath path, boolean includeEmptyDirs, CopyActionProcessingStreamAction delegateAction, Set<RelativePath> visitedDirs, ListMultimap<RelativePath, FileCopyDetailsInternal> pendingDirs) {
        if (path == null || path.getParent() == null || !visitedDirs.add(path)) {
            return;
        }
        this.maybeVisit(path.getParent(), includeEmptyDirs, delegateAction, visitedDirs, pendingDirs);
        List detailsForPath = pendingDirs.removeAll((Object)path);
        FileCopyDetailsInternal dir = detailsForPath.isEmpty() ? new StubbedFileCopyDetails(path, includeEmptyDirs, this.chmod) : (FileCopyDetailsInternal)detailsForPath.get(0);
        delegateAction.processFile(dir);
    }

    private /* synthetic */ void lambda$execute$1(CopyActionProcessingStream stream, Set visitedDirs, ListMultimap pendingDirs, CopyActionProcessingStreamAction action) {
        stream.process(details -> {
            if (details.isDirectory()) {
                RelativePath path = details.getRelativePath();
                if (!visitedDirs.contains(path)) {
                    pendingDirs.put((Object)path, (Object)details);
                }
            } else {
                this.maybeVisit(details.getRelativePath().getParent(), details.isIncludeEmptyDirs(), action, visitedDirs, (ListMultimap<RelativePath, FileCopyDetailsInternal>)pendingDirs);
                action.processFile(details);
            }
        });
        for (RelativePath path : new LinkedHashSet(pendingDirs.keySet())) {
            ArrayList detailsList = new ArrayList(pendingDirs.get((Object)path));
            for (FileCopyDetailsInternal details2 : detailsList) {
                if (!details2.isIncludeEmptyDirs()) continue;
                this.maybeVisit(path, details2.isIncludeEmptyDirs(), action, visitedDirs, (ListMultimap<RelativePath, FileCopyDetailsInternal>)pendingDirs);
            }
        }
        visitedDirs.clear();
        pendingDirs.clear();
    }

    private static class StubbedFileCopyDetails
    extends AbstractFileTreeElement
    implements FileCopyDetailsInternal {
        private final RelativePath path;
        private final boolean includeEmptyDirs;
        private long lastModified = System.currentTimeMillis();

        private StubbedFileCopyDetails(RelativePath path, boolean includeEmptyDirs, Chmod chmod) {
            super(chmod);
            this.path = path;
            this.includeEmptyDirs = includeEmptyDirs;
        }

        @Override
        public boolean isIncludeEmptyDirs() {
            return this.includeEmptyDirs;
        }

        public String getDisplayName() {
            return this.path.toString();
        }

        public File getFile() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            return !this.path.isFile();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getSize() {
            throw new UnsupportedOperationException();
        }

        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        public RelativePath getRelativePath() {
            return this.path;
        }

        public void exclude() {
            throw new UnsupportedOperationException();
        }

        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        public void setPath(String path) {
            throw new UnsupportedOperationException();
        }

        public void setRelativePath(RelativePath path) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public void setMode(int mode) {
            throw new UnsupportedOperationException();
        }

        public void permissions(Action<? super ConfigurableFilePermissions> configureAction) {
            throw new UnsupportedOperationException();
        }

        public void setPermissions(FilePermissions permissions) {
            throw new UnsupportedOperationException();
        }

        public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
            throw new UnsupportedOperationException();
        }

        public DuplicatesStrategy getDuplicatesStrategy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefaultDuplicatesStrategy() {
            throw new UnsupportedOperationException();
        }

        public String getSourceName() {
            throw new UnsupportedOperationException();
        }

        public String getSourcePath() {
            throw new UnsupportedOperationException();
        }

        public RelativePath getRelativeSourcePath() {
            throw new UnsupportedOperationException();
        }

        public ContentFilterable filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
            throw new UnsupportedOperationException();
        }

        public ContentFilterable filter(Class<? extends FilterReader> filterType) {
            throw new UnsupportedOperationException();
        }

        public ContentFilterable filter(Closure closure) {
            throw new UnsupportedOperationException();
        }

        public ContentFilterable filter(Transformer<String, String> transformer) {
            throw new UnsupportedOperationException();
        }

        public ContentFilterable expand(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        public ContentFilterable expand(Map<String, ?> properties, Action<? super ExpandDetails> action) {
            throw new UnsupportedOperationException();
        }
    }
}

