/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.MathUtil;

public class LimitedPool<T> {
    private final int myMaxCapacity;
    private final ObjectFactory<T> myFactory;
    private Object[] myStorage;
    private int myIndex;

    public LimitedPool(int maxCapacity, @NotNull ObjectFactory<T> factory) {
        if (factory == null) {
            LimitedPool.$$$reportNull$$$0(0);
        }
        this.myStorage = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        this.myMaxCapacity = maxCapacity;
        this.myFactory = factory;
    }

    @NotNull
    public T alloc() {
        if (this.myIndex == 0) {
            T t = this.myFactory.create();
            if (t == null) {
                LimitedPool.$$$reportNull$$$0(1);
            }
            return t;
        }
        int i = --this.myIndex;
        Object result2 = this.myStorage[i];
        this.myStorage[i] = null;
        Object object = result2;
        if (object == null) {
            LimitedPool.$$$reportNull$$$0(2);
        }
        return (T)object;
    }

    public void recycle(@NotNull T t) {
        if (t == null) {
            LimitedPool.$$$reportNull$$$0(3);
        }
        this.myFactory.cleanup(t);
        if (this.myIndex >= this.myMaxCapacity) {
            return;
        }
        this.ensureCapacity();
        this.myStorage[this.myIndex++] = t;
    }

    private void ensureCapacity() {
        if (this.myStorage.length <= this.myIndex) {
            int newCapacity = MathUtil.clamp(this.myStorage.length * 3 / 2, 10, this.myMaxCapacity);
            this.myStorage = ArrayUtil.realloc(this.myStorage, newCapacity, ArrayUtil.OBJECT_ARRAY_FACTORY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/LimitedPool";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/LimitedPool";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "alloc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "recycle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ObjectFactory<T> {
        @NotNull
        public T create();

        default public void cleanup(@NotNull T t) {
            if (t == null) {
                ObjectFactory.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/util/containers/LimitedPool$ObjectFactory", "cleanup"));
        }
    }
}

