/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceBackedByArray;

public class CharArrayCharSequence
implements CharSequenceWithStringHash,
CharSequenceBackedByArray {
    protected final char[] myChars;
    protected final int myStart;
    protected final int myEnd;
    private transient int hash;

    public CharArrayCharSequence(char ... chars) {
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public CharArrayCharSequence(char @NotNull [] chars, int start, int end) {
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(1);
        }
        if (start < 0 || end > chars.length || start > end) {
            throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars[index + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.myEnd - this.myStart);
    }

    @Override
    public char @NotNull [] getChars() {
        if (this.myStart == 0) {
            if (this.myChars == null) {
                CharArrayCharSequence.$$$reportNull$$$0(2);
            }
            return this.myChars;
        }
        char[] chars = new char[this.length()];
        this.getChars(chars, 0);
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(3);
        }
        return chars;
    }

    @Override
    public void getChars(char @NotNull [] dst, int dstOffset) {
        if (dst == null) {
            CharArrayCharSequence.$$$reportNull$$$0(4);
        }
        System.arraycopy(this.myChars, this.myStart, dst, dstOffset, this.length());
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass() || this.length() != ((CharSequence)anObject).length()) {
            return false;
        }
        return CharArrayUtil.regionMatches(this.myChars, this.myStart, this.myEnd, (CharSequence)anObject);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this.myChars, this.myStart, this.myEnd);
        }
        return h;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/text/CharArrayCharSequence";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/text/CharArrayCharSequence";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

