/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.DoubleColonLHS;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentTypeMismatch;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ConeLambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConePostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.resolve.calls.DynamicReceiverExpectedButWasNonDynamic;
import org.jetbrains.kotlin.fir.resolve.calls.ErrorTypeInArguments;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.NullForNotNullType;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.UnsafeCall;
import org.jetbrains.kotlin.fir.resolve.calls.UnstableSmartCast;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaParameterType;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleterKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeExplicitTypeParameterConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeReceiverConstraintPosition;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableTypeConstructor;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011JT\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J:\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u001e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u001f\u001a\u00020\u0005*\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010\"\u001a\u00020\u0005*\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010#\u001a\u00020\u0011H\u0002J2\u0010\u0013\u001a\u00020\u0005*\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u00112\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J$\u0010$\u001a\u00020\u0005*\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\u00020\u0005*\u00020\u001e2\u0006\u0010\b\u001a\u00020)H\u0002J\u0014\u0010*\u001a\u00020+*\u00020\u001e2\u0006\u0010\b\u001a\u00020\u001bH\u0002J\u0016\u0010,\u001a\u0004\u0018\u00010-*\u00020\u001e2\u0006\u0010\b\u001a\u00020\u001bH\u0002J&\u0010.\u001a\u00020\u0018*\u00020\u001e2\u0006\u0010\b\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u001e\u00100\u001a\u00020\u0018*\u00020\u001e2\u0006\u0010\b\u001a\u00020\u001b2\b\u00101\u001a\u0004\u0018\u00010\u0016H\u0002J&\u00102\u001a\u0004\u0018\u00010\u000b*\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ArgumentCheckingProcessor;", "", "<init>", "()V", "resolveArgumentExpression", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "isReceiver", "", "isDispatch", "resolvePlainArgumentType", "argumentType", "sourceForReceiver", "Lorg/jetbrains/kotlin/KtSourceElement;", "createResolvedLambdaAtomDuringCompletion", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolvedLambdaAtom;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnonymousFunctionExpression;", "returnTypeVariable", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConeTypeVariableForLambdaReturnType;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ArgumentCheckingProcessor$ArgumentContext;", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolvePlainExpressionArgument", "useNullableArgumentType", "checkApplicabilityForArgumentType", "argumentTypeBeforeCapturing", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintPosition;", "preprocessCallableReference", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "preprocessLambdaArgument", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConePostponedResolvedAtom;", "createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeLambdaWithTypeVariableAsExpectedTypeAtom;", "createResolvedLambdaAtom", "duringCompletion", "extractLambdaInfo", "sourceForFunctionExpression", "argumentTypeWithCustomConversion", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "ArgumentContext", "resolve"})
@SourceDebugExtension(value={"SMAP\nArgumentCheckingProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentCheckingProcessor.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/ArgumentCheckingProcessor\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,452:1\n271#2:453\n226#2:455\n226#2:456\n1#3:454\n1#3:484\n1567#4:457\n1598#4,3:458\n1601#4:462\n1567#4:463\n1598#4,3:464\n1601#4:468\n1611#4,9:474\n1863#4:483\n1864#4:485\n1620#4:486\n26#5:461\n26#5:467\n26#5:469\n11165#6:470\n11500#6,3:471\n*S KotlinDebug\n*F\n+ 1 ArgumentCheckingProcessor.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/ArgumentCheckingProcessor\n*L\n183#1:453\n321#1:455\n390#1:456\n222#1:484\n392#1:457\n392#1:458,3\n392#1:462\n398#1:463\n398#1:464,3\n398#1:468\n222#1:474,9\n222#1:483\n222#1:485\n222#1:486\n393#1:461\n399#1:467\n413#1:469\n443#1:470\n443#1:471,3\n*E\n"})
public final class ArgumentCheckingProcessor {
    @NotNull
    public static final ArgumentCheckingProcessor INSTANCE = new ArgumentCheckingProcessor();

    private ArgumentCheckingProcessor() {
    }

    public final void resolveArgumentExpression(@NotNull Candidate candidate2, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context, boolean isReceiver, boolean isDispatch) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArgumentContext argumentContext = new ArgumentContext(candidate2, ConstraintSystemCompleterKt.getCsBuilder(candidate2), expectedType, sink, context, isReceiver, isDispatch);
        this.resolveArgumentExpression(argumentContext, argument);
    }

    public final void resolvePlainArgumentType(@NotNull Candidate candidate2, @NotNull FirExpression argument, @NotNull ConeKotlinType argumentType, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context, boolean isReceiver, boolean isDispatch, @Nullable KtSourceElement sourceForReceiver) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArgumentContext argumentContext = new ArgumentContext(candidate2, ConstraintSystemCompleterKt.getCsBuilder(candidate2), expectedType, sink, context, isReceiver, isDispatch);
        ArgumentCheckingProcessor.resolvePlainArgumentType$default(this, argumentContext, argument, argumentType, false, sourceForReceiver, 4, null);
    }

    public static /* synthetic */ void resolvePlainArgumentType$default(ArgumentCheckingProcessor argumentCheckingProcessor, Candidate candidate2, FirExpression firExpression, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, KtSourceElement ktSourceElement, int n, Object object) {
        if ((n & 0x100) != 0) {
            ktSourceElement = null;
        }
        argumentCheckingProcessor.resolvePlainArgumentType(candidate2, firExpression, coneKotlinType, coneKotlinType2, checkerSink, resolutionContext, bl, bl2, ktSourceElement);
    }

    @NotNull
    public final ConeResolvedLambdaAtom createResolvedLambdaAtomDuringCompletion(@NotNull Candidate candidate2, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirAnonymousFunctionExpression argument, @Nullable ConeKotlinType expectedType, @NotNull ResolutionContext context, @Nullable ConeTypeVariableForLambdaReturnType returnTypeVariable) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArgumentContext argumentContext = new ArgumentContext(candidate2, csBuilder, expectedType, null, context, false, false);
        return this.createResolvedLambdaAtom(argumentContext, argument, true, returnTypeVariable);
    }

    private final void resolveArgumentExpression(ArgumentContext $this$resolveArgumentExpression, FirExpression argument) {
        FirExpression firExpression = argument;
        if (firExpression instanceof FirSafeCallExpression) {
            FirExpression nestedQualifier;
            FirStatement firStatement = ((FirSafeCallExpression)argument).getSelector();
            FirExpression firExpression2 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
            FirExpression firExpression3 = nestedQualifier = firExpression2 != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression2) : null;
            if (nestedQualifier instanceof FirQualifiedAccessExpression) {
                this.resolvePlainExpressionArgument($this$resolveArgumentExpression, nestedQualifier, true);
            } else {
                this.checkApplicabilityForArgumentType($this$resolveArgumentExpression, argument, TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getUnit(), new ConeTypeProjection[0], false, null, 4, null), SimpleConstraintSystemConstraintPosition.INSTANCE);
            }
        } else if (firExpression instanceof FirCallableReferenceAccess) {
            if (((FirCallableReferenceAccess)argument).getCalleeReference() instanceof FirResolvedNamedReference) {
                ArgumentCheckingProcessor.resolvePlainExpressionArgument$default(this, $this$resolveArgumentExpression, argument, false, 2, null);
            } else {
                this.preprocessCallableReference($this$resolveArgumentExpression, (FirCallableReferenceAccess)argument);
            }
        } else if (firExpression instanceof FirAnonymousFunctionExpression) {
            this.preprocessLambdaArgument($this$resolveArgumentExpression, (FirAnonymousFunctionExpression)argument);
        } else if (firExpression instanceof FirWrappedArgumentExpression) {
            this.resolveArgumentExpression($this$resolveArgumentExpression, ((FirWrappedArgumentExpression)argument).getExpression());
        } else if (firExpression instanceof FirBlock) {
            this.resolveBlockArgument($this$resolveArgumentExpression, (FirBlock)argument);
        } else if (firExpression instanceof FirErrorExpression) {
            FirExpression wrappedExpression = ((FirErrorExpression)argument).getExpression();
            if (wrappedExpression == null) {
                ArgumentCheckingProcessor.resolvePlainExpressionArgument$default(this, $this$resolveArgumentExpression, argument, false, 2, null);
            } else {
                this.resolveArgumentExpression($this$resolveArgumentExpression, wrappedExpression);
            }
        } else {
            ArgumentCheckingProcessor.resolvePlainExpressionArgument$default(this, $this$resolveArgumentExpression, argument, false, 2, null);
        }
    }

    private final void resolveBlockArgument(ArgumentContext $this$resolveBlockArgument, FirBlock block) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            ArgumentContext newContext = ArgumentContext.copy$default($this$resolveBlockArgument, null, null, null, null, null, false, false, 31, null);
            this.checkApplicabilityForArgumentType(newContext, block, FirTypeUtilsKt.getResolvedType(block), SimpleConstraintSystemConstraintPosition.INSTANCE);
            return;
        }
        for (FirExpression argument : returnArguments) {
            this.resolveArgumentExpression($this$resolveBlockArgument, argument);
        }
    }

    private final void resolvePlainExpressionArgument(ArgumentContext $this$resolvePlainExpressionArgument, FirExpression argument, boolean useNullableArgumentType) {
        if ($this$resolvePlainExpressionArgument.getExpectedType() == null) {
            return;
        }
        if (argument instanceof FirArrayLiteral && !FirTypeUtilsKt.isResolved(argument)) {
            return;
        }
        ConeKotlinType argumentType = FirTypeUtilsKt.getResolvedType(argument);
        ArgumentCheckingProcessor.resolvePlainArgumentType$default(this, $this$resolvePlainExpressionArgument, argument, argumentType, useNullableArgumentType, null, 8, null);
    }

    static /* synthetic */ void resolvePlainExpressionArgument$default(ArgumentCheckingProcessor argumentCheckingProcessor, ArgumentContext argumentContext, FirExpression firExpression, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        argumentCheckingProcessor.resolvePlainExpressionArgument(argumentContext, firExpression, bl);
    }

    private final void resolvePlainArgumentType(ArgumentContext $this$resolvePlainArgumentType, FirExpression argument, ConeKotlinType argumentType, boolean useNullableArgumentType, KtSourceElement sourceForReceiver) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2;
        ConstraintPosition position = $this$resolvePlainArgumentType.isReceiver() ? new ConeReceiverConstraintPosition(argument, sourceForReceiver) : new ConeArgumentConstraintPosition(argument);
        ConeKotlinType capturedType = ArgumentUtilsKt.prepareCapturedType(argumentType, $this$resolvePlainArgumentType.getContext());
        ConeKotlinType argumentTypeForApplicabilityCheck = null;
        ConeKotlinType $this$applyIf$iv = capturedType;
        boolean $i$f$applyIf = false;
        if (useNullableArgumentType) {
            ConeKotlinType $this$resolvePlainArgumentType_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            coneKotlinType2 = TypeUtilsKt.withNullability$default($this$resolvePlainArgumentType_u24lambda_u240, ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext($this$resolvePlainArgumentType.getSession()), null, false, 12, null);
        } else {
            coneKotlinType2 = argumentTypeForApplicabilityCheck = $this$applyIf$iv;
        }
        if ($this$resolvePlainArgumentType.getExpectedType() != null && (coneKotlinType = this.argumentTypeWithCustomConversion($this$resolvePlainArgumentType.getContext().getTypeContext(), $this$resolvePlainArgumentType.getSession(), $this$resolvePlainArgumentType.getExpectedType(), argumentTypeForApplicabilityCheck)) != null) {
            ConeKotlinType it = coneKotlinType;
            boolean bl = false;
            argumentTypeForApplicabilityCheck = it;
            $this$resolvePlainArgumentType.getCandidate().getSubstitutor().substituteOrSelf(argumentTypeForApplicabilityCheck);
            $this$resolvePlainArgumentType.getCandidate().setUsesFunctionConversion(true);
        }
        this.checkApplicabilityForArgumentType($this$resolvePlainArgumentType, argument, argumentTypeForApplicabilityCheck, position);
    }

    static /* synthetic */ void resolvePlainArgumentType$default(ArgumentCheckingProcessor argumentCheckingProcessor, ArgumentContext argumentContext, FirExpression firExpression, ConeKotlinType coneKotlinType, boolean bl, KtSourceElement ktSourceElement, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            ktSourceElement = null;
        }
        argumentCheckingProcessor.resolvePlainArgumentType(argumentContext, firExpression, coneKotlinType, bl, ktSourceElement);
    }

    private final void checkApplicabilityForArgumentType(ArgumentContext $this$checkApplicabilityForArgumentType, FirExpression argument, ConeKotlinType argumentTypeBeforeCapturing, ConstraintPosition position) {
        if ($this$checkApplicabilityForArgumentType.getExpectedType() == null) {
            return;
        }
        ConeKotlinType argumentType = ArgumentUtilsKt.captureFromTypeParameterUpperBoundIfNeeded(argumentTypeBeforeCapturing, $this$checkApplicabilityForArgumentType.getExpectedType(), $this$checkApplicabilityForArgumentType.getSession());
        if ($this$checkApplicabilityForArgumentType.isReceiver() && $this$checkApplicabilityForArgumentType.isDispatch()) {
            if (!ConeTypeUtilsKt.isNullable($this$checkApplicabilityForArgumentType.getExpectedType()) && ConeTypeUtilsKt.isMarkedNullable(argumentType)) {
                $this$checkApplicabilityForArgumentType.reportDiagnostic(new InapplicableWrongReceiver($this$checkApplicabilityForArgumentType.getExpectedType(), argumentType));
            }
        } else if ($this$checkApplicabilityForArgumentType.isReceiver() && $this$checkApplicabilityForArgumentType.getExpectedType() instanceof ConeDynamicType && !(argumentType instanceof ConeDynamicType)) {
            $this$checkApplicabilityForArgumentType.reportDiagnostic(new DynamicReceiverExpectedButWasNonDynamic(argumentType));
        } else {
            FirSmartCastExpression smartcastExpression;
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($this$checkApplicabilityForArgumentType.getCsBuilder(), argumentType, $this$checkApplicabilityForArgumentType.getExpectedType(), position)) {
                return;
            }
            FirSmartCastExpression firSmartCastExpression = smartcastExpression = argument instanceof FirSmartCastExpression ? (FirSmartCastExpression)argument : null;
            if (smartcastExpression != null && !smartcastExpression.isStable()) {
                ConeKotlinType unstableType = FirTypeUtilsKt.getConeType(smartcastExpression.getSmartcastType());
                if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($this$checkApplicabilityForArgumentType.getCsBuilder(), unstableType, $this$checkApplicabilityForArgumentType.getExpectedType(), position)) {
                    $this$checkApplicabilityForArgumentType.reportDiagnostic(new UnstableSmartCast(smartcastExpression, $this$checkApplicabilityForArgumentType.getExpectedType(), org.jetbrains.kotlin.fir.types.InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext($this$checkApplicabilityForArgumentType.getSession()), argumentType, $this$checkApplicabilityForArgumentType.getExpectedType()), false));
                    return;
                }
            }
            if (!$this$checkApplicabilityForArgumentType.isReceiver()) {
                $this$checkApplicabilityForArgumentType.reportDiagnostic(ArgumentCheckingProcessor.checkApplicabilityForArgumentType$subtypeError(argument, argumentType, $this$checkApplicabilityForArgumentType, $this$checkApplicabilityForArgumentType.getExpectedType()));
                return;
            }
            ConeKotlinType nullableExpectedType = TypeUtilsKt.withNullability$default($this$checkApplicabilityForArgumentType.getExpectedType(), ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext($this$checkApplicabilityForArgumentType.getSession()), null, false, 12, null);
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($this$checkApplicabilityForArgumentType.getCsBuilder(), argumentType, nullableExpectedType, position)) {
                $this$checkApplicabilityForArgumentType.reportDiagnostic(new UnsafeCall(argumentType));
            } else {
                $this$checkApplicabilityForArgumentType.getCsBuilder().addSubtypeConstraint(argumentType, $this$checkApplicabilityForArgumentType.getExpectedType(), position);
                $this$checkApplicabilityForArgumentType.reportDiagnostic(new InapplicableWrongReceiver($this$checkApplicabilityForArgumentType.getExpectedType(), argumentType));
            }
        }
    }

    private final void preprocessCallableReference(ArgumentContext $this$preprocessCallableReference, FirCallableReferenceAccess argument) {
        DoubleColonLHS lhs = $this$preprocessCallableReference.getContext().getBodyResolveComponents().getDoubleColonExpressionResolver().resolveDoubleColonLHS$resolve(argument);
        $this$preprocessCallableReference.getCandidate().addPostponedAtom(new ConeResolvedCallableReferenceAtom(argument, $this$preprocessCallableReference.getExpectedType(), lhs, $this$preprocessCallableReference.getContext().getSession()));
    }

    private final ConePostponedResolvedAtom preprocessLambdaArgument(ArgumentContext $this$preprocessLambdaArgument, FirAnonymousFunctionExpression argument) {
        ConeLambdaWithTypeVariableAsExpectedTypeAtom coneLambdaWithTypeVariableAsExpectedTypeAtom = this.createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded($this$preprocessLambdaArgument, argument);
        if (coneLambdaWithTypeVariableAsExpectedTypeAtom != null) {
            ConeLambdaWithTypeVariableAsExpectedTypeAtom it = coneLambdaWithTypeVariableAsExpectedTypeAtom;
            boolean bl = false;
            return it;
        }
        return this.createResolvedLambdaAtom($this$preprocessLambdaArgument, argument, false, null);
    }

    private final ConeLambdaWithTypeVariableAsExpectedTypeAtom createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded(ArgumentContext $this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded, FirAnonymousFunctionExpression argument) {
        Object object;
        Object v1;
        Object object2;
        block5: {
            if ($this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getExpectedType() == null || !$this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getCsBuilder().isTypeVariable($this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getExpectedType())) {
                return null;
            }
            VariableWithConstraints variableWithConstraints = $this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getCsBuilder().currentStorage().getNotFixedTypeVariables().get(TypeSystemContextHelpersKt.typeConstructor($this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getExpectedType(), $this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getContext().getTypeContext()));
            if (variableWithConstraints == null) {
                return null;
            }
            VariableWithConstraints expectedTypeVariableWithConstraints = variableWithConstraints;
            Iterable iterable = expectedTypeVariableWithConstraints.getConstraints();
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                Object t = object2.next();
                Constraint it = (Constraint)t;
                boolean bl = false;
                if (!(it.getKind() == ConstraintKind.EQUALITY && it.getPosition().getFrom() instanceof ConeExplicitTypeParameterConstraintPosition)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        Constraint constraint = v1;
        ConeKotlinType explicitTypeArgument = (ConeKotlinType)(constraint != null ? constraint.getType() : null);
        boolean condition$iv = explicitTypeArgument == null || !(explicitTypeArgument.getTypeArguments().length == 0);
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            Object it = object2 = new ConeLambdaWithTypeVariableAsExpectedTypeAtom(argument, $this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getExpectedType(), $this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getCandidate());
            boolean bl2 = false;
            $this$createLambdaWithTypeVariableAsExpectedTypeAtomIfNeeded.getCandidate().addPostponedAtom((ConePostponedResolvedAtom)it);
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    private final ConeResolvedLambdaAtom createResolvedLambdaAtom(ArgumentContext $this$createResolvedLambdaAtom, FirAnonymousFunctionExpression argument, boolean duringCompletion, ConeTypeVariableForLambdaReturnType returnTypeVariable) {
        ConeResolvedLambdaAtom resolvedArgument;
        FirAnonymousFunction anonymousFunction = argument.getAnonymousFunction();
        ConeResolvedLambdaAtom coneResolvedLambdaAtom = InferenceUtilsKt.extractLambdaInfoFromFunctionType($this$createResolvedLambdaAtom.getExpectedType(), argument, argument.getAnonymousFunction(), returnTypeVariable, $this$createResolvedLambdaAtom.getContext().getBodyResolveComponents(), $this$createResolvedLambdaAtom.getCandidate(), duringCompletion, argument.getSource());
        if (coneResolvedLambdaAtom == null) {
            coneResolvedLambdaAtom = resolvedArgument = this.extractLambdaInfo($this$createResolvedLambdaAtom, argument, argument.getSource());
        }
        if ($this$createResolvedLambdaAtom.getExpectedType() != null) {
            List<ConeKotlinType> parameters = resolvedArgument.getParameters();
            FunctionTypeKind functionTypeKind = FirFunctionTypeKindServiceKt.getFunctionTypeService($this$createResolvedLambdaAtom.getContext().getSession()).extractSingleSpecialKindForFunction(anonymousFunction.getSymbol());
            if (functionTypeKind == null) {
                FunctionTypeKind functionTypeKind2 = resolvedArgument.getExpectedFunctionTypeKind();
                functionTypeKind = functionTypeKind2 != null ? functionTypeKind2.nonReflectKind() : null;
                if (functionTypeKind == null) {
                    functionTypeKind = FunctionTypeKind.Function.INSTANCE;
                }
            }
            FunctionTypeKind functionTypeKind3 = functionTypeKind;
            ConeLookupTagBasedType lambdaType = ResolveUtilsKt.createFunctionType(functionTypeKind3, parameters, resolvedArgument.getReceiver(), resolvedArgument.getReturnType(), resolvedArgument.getContextReceivers());
            ConeArgumentConstraintPosition position = new ConeArgumentConstraintPosition(resolvedArgument.getFir());
            if (duringCompletion) {
                $this$createResolvedLambdaAtom.getCsBuilder().addSubtypeConstraint(lambdaType, $this$createResolvedLambdaAtom.getExpectedType(), position);
            } else if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($this$createResolvedLambdaAtom.getCsBuilder(), lambdaType, $this$createResolvedLambdaAtom.getExpectedType(), position)) {
                $this$createResolvedLambdaAtom.reportDiagnostic(new ArgumentTypeMismatch($this$createResolvedLambdaAtom.getExpectedType(), lambdaType, argument, org.jetbrains.kotlin.fir.types.InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext($this$createResolvedLambdaAtom.getContext().getSession()), lambdaType, $this$createResolvedLambdaAtom.getExpectedType())));
            }
        }
        return resolvedArgument;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeResolvedLambdaAtom extractLambdaInfo(ArgumentContext $this$extractLambdaInfo, FirAnonymousFunctionExpression argument, KtSourceElement sourceForFunctionExpression) {
        Object object;
        ConeKotlinType coneKotlinType;
        void $this$mapIndexedTo$iv$iv;
        int n;
        Collection collection;
        void $this$mapIndexedTo$iv$iv2;
        ConeDynamicType coneDynamicType;
        ConeKotlinType coneKotlinType2 = $this$extractLambdaInfo.getExpectedType();
        if (!((coneKotlinType2 != null && (coneKotlinType2 = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType2)) != null ? FunctionalTypeUtilsKt.functionTypeKind((ConeSimpleKotlinType)coneKotlinType2, $this$extractLambdaInfo.getSession()) : null) == null)) {
            boolean $i$a$-require-ArgumentCheckingProcessor$extractLambdaInfo$22 = false;
            String $i$a$-require-ArgumentCheckingProcessor$extractLambdaInfo$22 = "Currently, we only extract lambda info from its shape when expected type is not function, but " + $this$extractLambdaInfo.getExpectedType();
            throw new IllegalArgumentException($i$a$-require-ArgumentCheckingProcessor$extractLambdaInfo$22.toString());
        }
        FirAnonymousFunction lambda = argument.getAnonymousFunction();
        ConeTypeVariableForLambdaReturnType typeVariable = new ConeTypeVariableForLambdaReturnType(lambda, "_L");
        ConeKotlinType receiverType = org.jetbrains.kotlin.fir.types.InferenceUtilsKt.getReceiverType(lambda);
        ConeKotlinType coneKotlinType3 = org.jetbrains.kotlin.fir.types.InferenceUtilsKt.getReturnType(lambda);
        if (coneKotlinType3 == null) {
            coneKotlinType3 = typeVariable.getDefaultType();
        }
        ConeKotlinType returnType = coneKotlinType3;
        boolean condition$iv = Intrinsics.areEqual((Object)$this$extractLambdaInfo.getCandidate().getSymbol().getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE);
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            coneDynamicType = TypeUtilsKt.create$default(ConeDynamicType.Companion, $this$extractLambdaInfo.getSession(), null, 2, null);
        } else {
            coneDynamicType = null;
        }
        ConeDynamicType defaultType = coneDynamicType;
        Iterable $this$mapIndexed$iv = lambda.getValueParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
            ConeKotlinType coneKotlinType4;
            void it;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            int n3 = n2;
            collection = destination$iv$iv;
            n = 0;
            Object $this$coneTypeSafe$iv = it.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType5 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType5 instanceof ConeKotlinType)) {
                coneKotlinType5 = coneKotlinType4 = null;
            }
            if (coneKotlinType5 == null) {
                ConeDynamicType coneDynamicType2 = defaultType;
                if (coneDynamicType2 != null) {
                    coneKotlinType4 = coneDynamicType2;
                } else {
                    void i;
                    Object $this$extractLambdaInfo_u24lambda_u2410_u24lambda_u249 = $this$coneTypeSafe$iv = new ConeTypeVariableForLambdaParameterType("_P" + (int)i);
                    boolean bl = false;
                    $this$extractLambdaInfo.getCsBuilder().registerVariable((TypeVariableMarker)$this$extractLambdaInfo_u24lambda_u2410_u24lambda_u249);
                    coneKotlinType4 = ((ConeTypeVariable)$this$coneTypeSafe$iv).getDefaultType();
                }
            }
            collection.add(coneKotlinType4);
        }
        List parameters = (List)destination$iv$iv;
        Iterable $this$mapIndexed$iv2 = lambda.getContextReceivers();
        boolean $i$f$mapIndexed2 = false;
        destination$iv$iv = $this$mapIndexed$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
        boolean $i$f$mapIndexedTo2 = false;
        int index$iv$iv2 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            ConeKotlinType coneKotlinType6;
            void it;
            int n4;
            if ((n4 = index$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirContextReceiver i = (FirContextReceiver)item$iv$iv;
            n = n4;
            collection = destination$iv$iv2;
            boolean bl = false;
            FirTypeRef $this$coneTypeSafe$iv = it.getTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType7 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType7 instanceof ConeKotlinType)) {
                coneKotlinType7 = coneKotlinType6 = null;
            }
            if (coneKotlinType7 == null) {
                ConeDynamicType coneDynamicType3 = defaultType;
                if (coneDynamicType3 != null) {
                    coneKotlinType6 = coneDynamicType3;
                } else {
                    void i2;
                    ConeTypeVariableForLambdaParameterType coneTypeVariableForLambdaParameterType;
                    ConeTypeVariableForLambdaParameterType $this$extractLambdaInfo_u24lambda_u2412_u24lambda_u2411 = coneTypeVariableForLambdaParameterType = new ConeTypeVariableForLambdaParameterType("_C" + (int)i2);
                    boolean bl2 = false;
                    $this$extractLambdaInfo.getCsBuilder().registerVariable($this$extractLambdaInfo_u24lambda_u2412_u24lambda_u2411);
                    coneKotlinType6 = coneTypeVariableForLambdaParameterType.getDefaultType();
                }
            }
            collection.add(coneKotlinType6);
        }
        List contextReceivers = (List)destination$iv$iv2;
        boolean newTypeVariableUsed = Intrinsics.areEqual((Object)returnType, (Object)typeVariable.getDefaultType());
        if (newTypeVariableUsed) {
            $this$extractLambdaInfo.getCsBuilder().registerVariable(typeVariable);
        }
        ConeKotlinType coneKotlinType8 = $this$extractLambdaInfo.getExpectedType();
        Object $this$coneTypeSafe$iv = lambda.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType9 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType9 instanceof ConeKotlinType)) {
            coneKotlinType9 = coneKotlinType = null;
        }
        $this$coneTypeSafe$iv = object = typeVariable;
        ConeKotlinType coneKotlinType10 = returnType;
        List list = parameters;
        List list2 = contextReceivers;
        ConeKotlinType coneKotlinType11 = receiverType;
        FunctionTypeKind functionTypeKind = coneKotlinType9 != null && (coneKotlinType = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType)) != null ? FunctionalTypeUtilsKt.functionTypeKind((ConeSimpleKotlinType)coneKotlinType, $this$extractLambdaInfo.getSession()) : null;
        ConeKotlinType coneKotlinType12 = coneKotlinType8;
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = argument;
        FirAnonymousFunction firAnonymousFunction = lambda;
        boolean bl = false;
        boolean bl3 = newTypeVariableUsed;
        KtSourceElement ktSourceElement = sourceForFunctionExpression;
        boolean bl4 = false;
        ConeTypeVariableForLambdaReturnType coneTypeVariableForLambdaReturnType = bl3 ? object : null;
        ConeKotlinType coneKotlinType13 = coneKotlinType10;
        List list3 = list;
        List list4 = list2;
        ConeKotlinType coneKotlinType14 = coneKotlinType11;
        FunctionTypeKind functionTypeKind2 = functionTypeKind;
        ConeKotlinType coneKotlinType15 = coneKotlinType12;
        FirAnonymousFunctionExpression firAnonymousFunctionExpression2 = firAnonymousFunctionExpression;
        FirAnonymousFunction firAnonymousFunction2 = firAnonymousFunction;
        Object it = object = new ConeResolvedLambdaAtom(firAnonymousFunction2, firAnonymousFunctionExpression2, coneKotlinType15, functionTypeKind2, coneKotlinType14, list4, list3, coneKotlinType13, coneTypeVariableForLambdaReturnType, bl4, ktSourceElement);
        boolean bl5 = false;
        $this$extractLambdaInfo.getCandidate().addPostponedAtom((ConePostponedResolvedAtom)it);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType argumentTypeWithCustomConversion(ConeInferenceContext $this$argumentTypeWithCustomConversion, FirSession session2, ConeKotlinType expectedType, ConeKotlinType argumentType) {
        void $this$mapTo$iv$iv;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind(expectedType, session2);
        if (functionTypeKind == null) {
            return null;
        }
        FunctionTypeKind expectedTypeKind = functionTypeKind;
        if (FunctionTypeKindKt.isBasicFunctionOrKFunction(expectedTypeKind)) {
            return null;
        }
        ConeClassLikeType expectedFunctionType = FunctionalTypeUtilsKt.customFunctionTypeToSimpleFunctionType(expectedType, session2);
        ConeKotlinType coneKotlinType = FunctionalTypeUtilsKt.findSubtypeOfBasicFunctionType(argumentType, session2, expectedFunctionType);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType argumentTypeWithInvoke = coneKotlinType;
        List<SimpleTypeMarker> list = $this$argumentTypeWithCustomConversion.fastCorrespondingSupertypes(ConeTypeUtilsKt.unwrapLowerBound(argumentTypeWithInvoke), $this$argumentTypeWithCustomConversion.typeConstructor(expectedFunctionType));
        Object object = list != null ? (SimpleTypeMarker)CollectionsKt.firstOrNull(list) : null;
        ConeKotlinType coneKotlinType2 = object instanceof ConeKotlinType ? (ConeKotlinType)object : null;
        if (coneKotlinType2 == null) {
            return null;
        }
        ConeKotlinType functionType = coneKotlinType2;
        ConeTypeProjection[] $this$map$iv = functionType.getTypeArguments();
        boolean $i$f$map = false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var18_18 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType3 = ConeTypeProjectionKt.getType((ConeTypeProjection)it);
            if (coneKotlinType3 == null) {
                coneKotlinType3 = session2.getBuiltinTypes().getNullableAnyType().getType();
            }
            collection.add(coneKotlinType3);
        }
        object = (List)destination$iv$iv;
        if (object.isEmpty()) {
            boolean bl = false;
            return null;
        }
        List typeArguments = (List)object;
        return ResolveUtilsKt.createFunctionType$default(expectedTypeKind, typeArguments.subList(0, CollectionsKt.getLastIndex((List)typeArguments)), null, (ConeKotlinType)CollectionsKt.last((List)typeArguments), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType(ArgumentContext $this_checkApplicabilityForArgumentType, ConeKotlinType type2) {
        if (type2 instanceof ConeTypeVariableType) {
            ConeTypeParameterLookupTag originalTypeParameter;
            List list;
            Iterable $this$mapNotNull$iv;
            List<Constraint> constraints;
            ConeTypeVariableTypeConstructor lookupTag = ((ConeTypeVariableType)type2).getTypeConstructor();
            VariableWithConstraints variableWithConstraints = $this_checkApplicabilityForArgumentType.getCsBuilder().currentStorage().getNotFixedTypeVariables().get(lookupTag);
            List<Constraint> list2 = constraints = variableWithConstraints != null ? variableWithConstraints.getConstraints() : null;
            if (list2 != null) {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ConeKotlinType it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    Constraint it = (Constraint)element$iv$iv;
                    boolean bl2 = false;
                    KotlinTypeMarker kotlinTypeMarker = it.getType();
                    if ((kotlinTypeMarker instanceof ConeKotlinType ? (ConeKotlinType)kotlinTypeMarker : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List constraintTypes = list;
            $this$mapNotNull$iv = constraintTypes;
            if (!($this$mapNotNull$iv == null || $this$mapNotNull$iv.isEmpty())) {
                return ConeTypeIntersector.INSTANCE.intersectTypes(TypeComponentsKt.getTypeContext($this_checkApplicabilityForArgumentType.getSession()), constraintTypes);
            }
            TypeParameterMarker typeParameterMarker = lookupTag.getOriginalTypeParameter();
            ConeTypeParameterLookupTag coneTypeParameterLookupTag = originalTypeParameter = typeParameterMarker instanceof ConeTypeParameterLookupTag ? (ConeTypeParameterLookupTag)typeParameterMarker : null;
            if (originalTypeParameter != null) {
                return new ConeTypeParameterTypeImpl(originalTypeParameter, ConeTypeUtilsKt.isNullable(type2), ((ConeTypeVariableType)type2).getAttributes());
            }
        } else if (type2 instanceof ConeIntegerLiteralType) {
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)CollectionsKt.firstOrNull((Iterable)((ConeIntegerLiteralType)type2).getPossibleTypes());
            return coneClassLikeType != null ? (ConeKotlinType)coneClassLikeType : type2;
        }
        return type2;
    }

    private static final ResolutionDiagnostic checkApplicabilityForArgumentType$subtypeError(FirExpression $argument, ConeKotlinType argumentType, ArgumentContext $this_checkApplicabilityForArgumentType, ConeKotlinType actualExpectedType) {
        if (FirTypeUtilsKt.isNullLiteral($argument) && actualExpectedType.getNullability() == ConeNullability.NOT_NULL) {
            return new NullForNotNullType($argument, actualExpectedType);
        }
        if (argumentType instanceof ConeErrorType || actualExpectedType instanceof ConeErrorType) {
            return ErrorTypeInArguments.INSTANCE;
        }
        ConeKotlinType preparedExpectedType = ArgumentCheckingProcessor.checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType($this_checkApplicabilityForArgumentType, actualExpectedType);
        ConeKotlinType preparedActualType = ArgumentCheckingProcessor.checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType($this_checkApplicabilityForArgumentType, argumentType);
        return new ArgumentTypeMismatch(preparedExpectedType, preparedActualType, $argument, org.jetbrains.kotlin.fir.types.InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext($this_checkApplicabilityForArgumentType.getSession()), argumentType, actualExpectedType));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010(\u001a\u00020\u000bH\u00c6\u0003J\t\u0010)\u001a\u00020\rH\u00c6\u0003J\t\u0010*\u001a\u00020\rH\u00c6\u0003JS\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u00c6\u0001J\u0013\u0010,\u001a\u00020\r2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ArgumentCheckingProcessor$ArgumentContext;", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "isReceiver", "", "isDispatch", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;ZZ)V", "getCandidate", "()Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "getCsBuilder", "()Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "getExpectedType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSink", "()Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "getContext", "()Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "()Z", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "reportDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "", "resolve"})
    private static final class ArgumentContext {
        @NotNull
        private final Candidate candidate;
        @NotNull
        private final ConstraintSystemBuilder csBuilder;
        @Nullable
        private final ConeKotlinType expectedType;
        @Nullable
        private final CheckerSink sink;
        @NotNull
        private final ResolutionContext context;
        private final boolean isReceiver;
        private final boolean isDispatch;

        public ArgumentContext(@NotNull Candidate candidate2, @NotNull ConstraintSystemBuilder csBuilder, @Nullable ConeKotlinType expectedType, @Nullable CheckerSink sink, @NotNull ResolutionContext context, boolean isReceiver, boolean isDispatch) {
            Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
            Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.candidate = candidate2;
            this.csBuilder = csBuilder;
            this.expectedType = expectedType;
            this.sink = sink;
            this.context = context;
            this.isReceiver = isReceiver;
            this.isDispatch = isDispatch;
        }

        @NotNull
        public final Candidate getCandidate() {
            return this.candidate;
        }

        @NotNull
        public final ConstraintSystemBuilder getCsBuilder() {
            return this.csBuilder;
        }

        @Nullable
        public final ConeKotlinType getExpectedType() {
            return this.expectedType;
        }

        @Nullable
        public final CheckerSink getSink() {
            return this.sink;
        }

        @NotNull
        public final ResolutionContext getContext() {
            return this.context;
        }

        public final boolean isReceiver() {
            return this.isReceiver;
        }

        public final boolean isDispatch() {
            return this.isDispatch;
        }

        @NotNull
        public final FirSession getSession() {
            return this.context.getSession();
        }

        public final void reportDiagnostic(@NotNull ResolutionDiagnostic diagnostic) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                CheckerSink checkerSink = this.sink;
                if (checkerSink == null) break block0;
                checkerSink.reportDiagnostic(diagnostic);
            }
        }

        @NotNull
        public final Candidate component1() {
            return this.candidate;
        }

        @NotNull
        public final ConstraintSystemBuilder component2() {
            return this.csBuilder;
        }

        @Nullable
        public final ConeKotlinType component3() {
            return this.expectedType;
        }

        @Nullable
        public final CheckerSink component4() {
            return this.sink;
        }

        @NotNull
        public final ResolutionContext component5() {
            return this.context;
        }

        public final boolean component6() {
            return this.isReceiver;
        }

        public final boolean component7() {
            return this.isDispatch;
        }

        @NotNull
        public final ArgumentContext copy(@NotNull Candidate candidate2, @NotNull ConstraintSystemBuilder csBuilder, @Nullable ConeKotlinType expectedType, @Nullable CheckerSink sink, @NotNull ResolutionContext context, boolean isReceiver, boolean isDispatch) {
            Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
            Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new ArgumentContext(candidate2, csBuilder, expectedType, sink, context, isReceiver, isDispatch);
        }

        public static /* synthetic */ ArgumentContext copy$default(ArgumentContext argumentContext, Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                candidate2 = argumentContext.candidate;
            }
            if ((n & 2) != 0) {
                constraintSystemBuilder = argumentContext.csBuilder;
            }
            if ((n & 4) != 0) {
                coneKotlinType = argumentContext.expectedType;
            }
            if ((n & 8) != 0) {
                checkerSink = argumentContext.sink;
            }
            if ((n & 0x10) != 0) {
                resolutionContext = argumentContext.context;
            }
            if ((n & 0x20) != 0) {
                bl = argumentContext.isReceiver;
            }
            if ((n & 0x40) != 0) {
                bl2 = argumentContext.isDispatch;
            }
            return argumentContext.copy(candidate2, constraintSystemBuilder, coneKotlinType, checkerSink, resolutionContext, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ArgumentContext(candidate=" + this.candidate + ", csBuilder=" + this.csBuilder + ", expectedType=" + this.expectedType + ", sink=" + this.sink + ", context=" + this.context + ", isReceiver=" + this.isReceiver + ", isDispatch=" + this.isDispatch + ')';
        }

        public int hashCode() {
            int result2 = this.candidate.hashCode();
            result2 = result2 * 31 + this.csBuilder.hashCode();
            result2 = result2 * 31 + (this.expectedType == null ? 0 : this.expectedType.hashCode());
            result2 = result2 * 31 + (this.sink == null ? 0 : this.sink.hashCode());
            result2 = result2 * 31 + this.context.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isReceiver);
            result2 = result2 * 31 + Boolean.hashCode(this.isDispatch);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgumentContext)) {
                return false;
            }
            ArgumentContext argumentContext = (ArgumentContext)other;
            if (!Intrinsics.areEqual((Object)this.candidate, (Object)argumentContext.candidate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.csBuilder, (Object)argumentContext.csBuilder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expectedType, (Object)argumentContext.expectedType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sink, (Object)argumentContext.sink)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.context, (Object)argumentContext.context)) {
                return false;
            }
            if (this.isReceiver != argumentContext.isReceiver) {
                return false;
            }
            return this.isDispatch == argumentContext.isDispatch;
        }
    }
}

