/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.time.Instant;
import java.util.Map;
import org.gradle.api.NonNullApi;
import org.gradle.api.tasks.testing.TestEventReporter;
import org.gradle.api.tasks.testing.TestOutputEvent;

@NonNullApi
class LifecycleTrackingTestEventReporter<T extends TestEventReporter>
implements TestEventReporter {
    protected final T delegate;
    private State state = State.CREATED;

    LifecycleTrackingTestEventReporter(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public void started(Instant startTime) {
        if (this.state != State.CREATED) {
            throw new IllegalStateException("started(...) cannot be called twice");
        }
        this.state = State.STARTED;
        this.delegate.started(startTime);
    }

    @Override
    public void output(Instant logTime, TestOutputEvent.Destination destination, String output) {
        this.requireRunning();
        this.delegate.output(logTime, destination, output);
    }

    @Override
    public void metadata(Instant logTime, String key, Object value) {
        this.requireRunning();
        this.delegate.metadata(logTime, key, value);
    }

    @Override
    public void metadata(Instant logTime, Map<String, Object> values) {
        this.requireRunning();
        this.delegate.metadata(logTime, values);
    }

    @Override
    public void succeeded(Instant endTime) {
        this.markCompleted();
        this.delegate.succeeded(endTime);
    }

    @Override
    public void skipped(Instant endTime) {
        this.markCompleted();
        this.delegate.skipped(endTime);
    }

    @Override
    public void failed(Instant endTime, String message, String additionalContent) {
        this.markCompleted();
        this.delegate.failed(endTime, message, additionalContent);
    }

    @Override
    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.delegate.close();
        if (this.state == State.STARTED) {
            throw new IllegalStateException("completed(...) must be called before close() if started(...) was called");
        }
        this.state = State.CLOSED;
    }

    protected boolean isCompleted() {
        return this.state == State.CLOSED;
    }

    protected void requireRunning() {
        switch (this.state) {
            case CREATED: {
                throw new IllegalStateException("started(...) must be called before any other method");
            }
            case COMPLETED: {
                throw new IllegalStateException("completed(...) has already been called");
            }
            case CLOSED: {
                throw new IllegalStateException("close() has already been called");
            }
        }
    }

    protected void markCompleted() {
        this.requireRunning();
        this.state = State.COMPLETED;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @NonNullApi
    private static enum State {
        CREATED,
        STARTED,
        COMPLETED,
        CLOSED;

    }
}

