/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.tasks;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestExecuter;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestSelection;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestTestExecutionSpec;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class XCTest
extends AbstractTestTask {
    private final DirectoryProperty workingDirectory;
    private final DirectoryProperty testInstallDirectory;
    private final RegularFileProperty runScriptFile;

    public XCTest() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.workingDirectory = objectFactory.directoryProperty();
        this.testInstallDirectory = objectFactory.directoryProperty();
        this.runScriptFile = objectFactory.fileProperty();
    }

    protected XCTestTestExecutionSpec createTestExecutionSpec() {
        DefaultTestFilter testFilter = (DefaultTestFilter)this.getFilter();
        return new XCTestTestExecutionSpec((File)this.workingDirectory.getAsFile().get(), (File)this.runScriptFile.getAsFile().get(), this.getPath(), new XCTestSelection(testFilter.getIncludePatterns(), testFilter.getCommandLineIncludePatterns()));
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputDirectory
    public DirectoryProperty getTestInstallDirectory() {
        return this.testInstallDirectory;
    }

    @Internal(value="Covered by getRunScript")
    public RegularFileProperty getRunScriptFile() {
        return this.runScriptFile;
    }

    @Internal
    public DirectoryProperty getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected TestExecuter<XCTestTestExecutionSpec> createTestExecuter() {
        return (TestExecuter)this.getObjectFactory().newInstance(XCTestExecuter.class, new Object[0]);
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @SkipWhenEmpty
    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputFile
    protected File getRunScript() {
        RegularFile runScript = (RegularFile)this.getRunScriptFile().get();
        File runScriptFile = runScript.getAsFile();
        if (!runScriptFile.exists()) {
            return null;
        }
        return runScriptFile;
    }

    public XCTest setTestNameIncludePatterns(List<String> testNamePattern) {
        super.setTestNameIncludePatterns(testNamePattern);
        return this;
    }
}

