/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.serializer;

import java.util.List;
import org.gradle.internal.logging.events.SelectOptionPromptEvent;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;

public class SelectOptionPromptEventSerializer
implements Serializer<SelectOptionPromptEvent> {
    private final Serializer<List<String>> optionsSerializer = new ListSerializer(BaseSerializerFactory.STRING_SERIALIZER);

    public void write(Encoder encoder, SelectOptionPromptEvent value) throws Exception {
        encoder.writeLong(value.getTimestamp());
        encoder.writeString((CharSequence)value.getQuestion());
        this.optionsSerializer.write(encoder, value.getOptions());
        encoder.writeSmallInt(value.getDefaultOption());
    }

    public SelectOptionPromptEvent read(Decoder decoder) throws Exception {
        return new SelectOptionPromptEvent(decoder.readLong(), decoder.readString(), (List)this.optionsSerializer.read(decoder), decoder.readSmallInt());
    }
}

