/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.mtls;

import com.google.api.client.googleapis.mtls.ContextAwareMetadataJson;
import com.google.api.client.googleapis.mtls.MtlsProvider;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.Beta;
import com.google.api.client.util.SecurityUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;

@Beta
public class MtlsUtils {
    private static final MtlsProvider MTLS_PROVIDER = new DefaultMtlsProvider();

    public static MtlsProvider getDefaultMtlsProvider() {
        return MTLS_PROVIDER;
    }

    @VisibleForTesting
    static class DefaultMtlsProvider
    implements MtlsProvider {
        private static final String DEFAULT_CONTEXT_AWARE_METADATA_PATH = System.getProperty("user.home") + "/.secureConnect/context_aware_metadata.json";
        public static final String GOOGLE_API_USE_CLIENT_CERTIFICATE = "GOOGLE_API_USE_CLIENT_CERTIFICATE";
        private EnvironmentProvider envProvider;
        private String metadataPath;

        DefaultMtlsProvider() {
            this(new SystemEnvironmentProvider(), DEFAULT_CONTEXT_AWARE_METADATA_PATH);
        }

        @VisibleForTesting
        DefaultMtlsProvider(EnvironmentProvider envProvider, String metadataPath) {
            this.envProvider = envProvider;
            this.metadataPath = metadataPath;
        }

        @Override
        public boolean useMtlsClientCertificate() {
            String useClientCertificate = this.envProvider.getenv(GOOGLE_API_USE_CLIENT_CERTIFICATE);
            return "true".equals(useClientCertificate);
        }

        @Override
        public String getKeyStorePassword() {
            return "";
        }

        @Override
        public KeyStore getKeyStore() throws IOException, GeneralSecurityException {
            try {
                FileInputStream stream = new FileInputStream(this.metadataPath);
                List<String> command = DefaultMtlsProvider.extractCertificateProviderCommand(stream);
                Process process = new ProcessBuilder(command).start();
                int exitCode = DefaultMtlsProvider.runCertificateProviderCommand(process, 1000L);
                if (exitCode != 0) {
                    throw new IOException("Cert provider command failed with exit code: " + exitCode);
                }
                return SecurityUtils.createMtlsKeyStore((InputStream)process.getInputStream());
            }
            catch (FileNotFoundException ignored) {
                return null;
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted executing certificate provider command", e);
            }
        }

        @VisibleForTesting
        static List<String> extractCertificateProviderCommand(InputStream contextAwareMetadata) throws IOException {
            JsonParser parser = Utils.getDefaultJsonFactory().createJsonParser(contextAwareMetadata);
            ContextAwareMetadataJson json = (ContextAwareMetadataJson)((Object)parser.parse(ContextAwareMetadataJson.class));
            return json.getCommands();
        }

        @VisibleForTesting
        static int runCertificateProviderCommand(Process commandProcess, long timeoutMilliseconds) throws IOException, InterruptedException {
            long startTime = System.currentTimeMillis();
            long remainTime = timeoutMilliseconds;
            boolean terminated = false;
            while (true) {
                try {
                    commandProcess.exitValue();
                    terminated = true;
                }
                catch (IllegalThreadStateException ex) {
                    if (remainTime <= 0L) continue;
                    Thread.sleep(Math.min(remainTime + 1L, 100L));
                    if ((remainTime -= System.currentTimeMillis() - startTime) > 0L) continue;
                }
                break;
            }
            if (!terminated) {
                commandProcess.destroy();
                throw new IOException("cert provider command timed out");
            }
            return commandProcess.exitValue();
        }

        static class SystemEnvironmentProvider
        implements EnvironmentProvider {
            SystemEnvironmentProvider() {
            }

            @Override
            public String getenv(String name) {
                return System.getenv(name);
            }
        }

        static interface EnvironmentProvider {
            public String getenv(String var1);
        }
    }
}

