/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ComponentVariantNodeIdentifier;
import org.gradle.api.internal.artifacts.NodeIdentifier;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.dependencies.DefaultResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DefaultPendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DeselectVersionAction;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ReplaceSelectionWithConflictResultAction;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveOptimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RootNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ComponentStateFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.SelectorStateResolver;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphSpecificResolveState;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;

public class ResolveState
implements ComponentStateFactory<ComponentState> {
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final Map<ModuleIdentifier, ModuleResolveState> modules;
    private final Map<NodeIdentifier, NodeState> nodes;
    private final Map<SelectorCacheKey, SelectorState> selectors;
    private final RootNode root;
    private final ComponentIdGenerator idGenerator;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final Deque<NodeState> queue;
    private final ConflictResolution conflictResolution;
    private final ImmutableAttributesSchema consumerSchema;
    private final ModuleExclusions moduleExclusions;
    private final DeselectVersionAction deselectVersionAction = new DeselectVersionAction(this);
    private final ReplaceSelectionWithConflictResultAction replaceSelectionWithConflictResultAction;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final AttributesFactory attributesFactory;
    private final AttributeSchemaServices attributeSchemaServices;
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final VersionSelectorScheme versionSelectorScheme;
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;
    private final SelectorStateResolver<ComponentState> selectorStateResolver;
    private final ResolveOptimizations resolveOptimizations;
    private final Map<VersionConstraint, ResolvedVersionConstraint> resolvedVersionConstraints = new HashMap<VersionConstraint, ResolvedVersionConstraint>();
    private final AttributeDesugaring attributeDesugaring;
    private final ModuleConflictHandler moduleConflictHandler;
    private final CapabilitiesConflictHandler capabilitiesConflictHandler;
    private final GraphVariantSelector variantSelector;

    public ResolveState(ComponentIdGenerator idGenerator, LocalComponentGraphResolveState rootComponentState, LocalVariantGraphResolveState rootVariant, DependencyToComponentIdResolver idResolver, ComponentMetaDataResolver metaDataResolver, Spec<? super DependencyMetadata> edgeFilter, ModuleExclusions moduleExclusions, ComponentSelectorConverter componentSelectorConverter, AttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices, AttributeDesugaring attributeDesugaring, DependencySubstitutionApplicator dependencySubstitutionApplicator, VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser, ConflictResolution conflictResolution, List<? extends DependencyMetadata> syntheticDependencies, ModuleConflictHandler moduleConflictHandler, CapabilitiesConflictHandler capabilitiesConflictHandler, GraphVariantSelector variantSelector) {
        this.idGenerator = idGenerator;
        this.idResolver = idResolver;
        this.metaDataResolver = metaDataResolver;
        this.edgeFilter = edgeFilter;
        this.moduleExclusions = moduleExclusions;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributesFactory = attributesFactory;
        this.attributeSchemaServices = attributeSchemaServices;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator.asVersionComparator();
        this.versionParser = versionParser;
        this.conflictResolution = conflictResolution;
        this.moduleConflictHandler = moduleConflictHandler;
        this.capabilitiesConflictHandler = capabilitiesConflictHandler;
        this.resolveOptimizations = new ResolveOptimizations();
        this.attributeDesugaring = attributeDesugaring;
        this.replaceSelectionWithConflictResultAction = new ReplaceSelectionWithConflictResultAction(this);
        this.variantSelector = variantSelector;
        ModuleVersionIdentifier rootModuleVersionId = rootComponentState.getModuleVersionId();
        ComponentIdentifier rootComponentId = rootComponentState.getId();
        this.consumerSchema = rootComponentState.getMetadata().getAttributesSchema();
        int graphSize = ResolveState.estimateGraphSize(rootVariant);
        this.modules = new LinkedHashMap<ModuleIdentifier, ModuleResolveState>(graphSize);
        this.nodes = new LinkedHashMap<NodeIdentifier, NodeState>(3 * graphSize / 2);
        this.selectors = new LinkedHashMap<SelectorCacheKey, SelectorState>(5 * graphSize / 2);
        this.queue = new ArrayDeque<NodeState>(graphSize);
        ModuleResolveState rootModule = this.getModule(rootModuleVersionId.getModule(), true);
        ComponentState rootComponent = rootModule.getVersion(rootModuleVersionId, rootComponentId);
        rootComponent.setRoot();
        rootComponent.setState(rootComponentState, ComponentGraphSpecificResolveState.EMPTY_STATE);
        rootModule.select(rootComponent);
        this.selectorStateResolver = new SelectorStateResolver<ComponentState>(moduleConflictHandler.getResolver(), this, rootComponent, this.resolveOptimizations, this.versionComparator, versionParser);
        rootModule.setSelectorStateResolver(this.selectorStateResolver);
        this.root = new RootNode(idGenerator.nextGraphNodeId(), rootComponent, this, syntheticDependencies, rootVariant);
        rootComponent.addNode(this.root);
        ComponentVariantNodeIdentifier rootNodeId = new ComponentVariantNodeIdentifier(rootComponentId, rootVariant.getName());
        this.nodes.put(rootNodeId, this.root);
    }

    public ComponentIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public ModuleConflictHandler getModuleConflictHandler() {
        return this.moduleConflictHandler;
    }

    public CapabilitiesConflictHandler getCapabilitiesConflictHandler() {
        return this.capabilitiesConflictHandler;
    }

    public Collection<ModuleResolveState> getModules() {
        return this.modules.values();
    }

    Spec<? super DependencyMetadata> getEdgeFilter() {
        return this.edgeFilter;
    }

    RootNode getRoot() {
        return this.root;
    }

    public ModuleResolveState getModule(ModuleIdentifier id) {
        return this.getModule(id, false);
    }

    public ComponentMetaDataResolver getComponentMetadataResolver() {
        return this.metaDataResolver;
    }

    private ModuleResolveState getModule(ModuleIdentifier id, boolean rootModule) {
        return this.modules.computeIfAbsent(id, mid -> new ModuleResolveState(this.idGenerator, id, this.metaDataResolver, this.attributesFactory, this.versionComparator, this.versionParser, this.selectorStateResolver, this.resolveOptimizations, rootModule, this.conflictResolution));
    }

    @Override
    public ComponentState getRevision(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier id, ComponentGraphResolveState state, ComponentGraphSpecificResolveState graphState) {
        ComponentState componentState = this.getModule(id.getModule()).getVersion(id, componentIdentifier);
        if (!componentState.alreadyResolved()) {
            componentState.setState(state, graphState);
        }
        return componentState;
    }

    public Collection<NodeState> getNodes() {
        return this.nodes.values();
    }

    public NodeState getNode(ComponentState component, VariantGraphResolveState variant, boolean selectedByVariantAwareResolution) {
        ComponentVariantNodeIdentifier id = new ComponentVariantNodeIdentifier(component.getComponentId(), variant.getName());
        return this.nodes.computeIfAbsent(id, rci -> {
            NodeState node = new NodeState(this.idGenerator.nextGraphNodeId(), component, this, variant, selectedByVariantAwareResolution);
            component.addNode(node);
            return node;
        });
    }

    public Collection<SelectorState> getSelectors() {
        return this.selectors.values();
    }

    public SelectorState computeSelectorFor(DependencyState dependencyState, boolean ignoreVersion) {
        boolean isVirtualPlatformEdge = dependencyState.getDependency() instanceof LenientPlatformDependencyMetadata;
        SelectorState selectorState = this.selectors.computeIfAbsent(new SelectorCacheKey(dependencyState.getRequested(), ignoreVersion, isVirtualPlatformEdge), req -> {
            ModuleIdentifier moduleIdentifier = dependencyState.getModuleIdentifier();
            return new SelectorState(dependencyState, this.idResolver, this, moduleIdentifier, ignoreVersion);
        });
        selectorState.update(dependencyState);
        return selectorState;
    }

    @Nullable
    public NodeState peek() {
        return this.queue.isEmpty() ? null : this.queue.getFirst();
    }

    public NodeState pop() {
        NodeState next = this.queue.removeFirst();
        return next.dequeue();
    }

    public void onMoreSelected(NodeState node) {
        if (node.enqueue()) {
            this.queue.addLast(node);
        }
    }

    public void onFewerSelected(NodeState node) {
        if (node.enqueue()) {
            this.queue.addFirst(node);
        }
    }

    public ImmutableAttributesSchema getConsumerSchema() {
        return this.consumerSchema;
    }

    public ModuleExclusions getModuleExclusions() {
        return this.moduleExclusions;
    }

    public DeselectVersionAction getDeselectVersionAction() {
        return this.deselectVersionAction;
    }

    public ReplaceSelectionWithConflictResultAction getReplaceSelectionWithConflictResultAction() {
        return this.replaceSelectionWithConflictResultAction;
    }

    public ComponentSelectorConverter getComponentSelectorConverter() {
        return this.componentSelectorConverter;
    }

    public AttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    public AttributeSchemaServices getAttributeSchemaServices() {
        return this.attributeSchemaServices;
    }

    public DependencySubstitutionApplicator getDependencySubstitutionApplicator() {
        return this.dependencySubstitutionApplicator;
    }

    PendingDependenciesVisitor newPendingDependenciesVisitor() {
        return new DefaultPendingDependenciesVisitor(this);
    }

    @Nullable
    ResolvedVersionConstraint resolveVersionConstraint(ComponentSelector selector) {
        if (selector instanceof ModuleComponentSelector) {
            return this.resolveVersionConstraint(((ModuleComponentSelector)selector).getVersionConstraint());
        }
        return null;
    }

    ResolvedVersionConstraint resolveVersionConstraint(VersionConstraint vc) {
        return this.resolvedVersionConstraints.computeIfAbsent(vc, key -> new DefaultResolvedVersionConstraint((VersionConstraint)key, this.versionSelectorScheme));
    }

    ComponentSelector desugarSelector(ComponentSelector requested) {
        return this.attributeDesugaring.desugarSelector(requested);
    }

    AttributeDesugaring getAttributeDesugaring() {
        return this.attributeDesugaring;
    }

    ResolveOptimizations getResolveOptimizations() {
        return this.resolveOptimizations;
    }

    public GraphVariantSelector getVariantSelector() {
        return this.variantSelector;
    }

    private static int estimateGraphSize(VariantGraphResolveState rootVariant) {
        int numDependencies = rootVariant.getDependencies().size();
        int estimate = (int)(512.0 * Math.log(numDependencies));
        return Math.max(10, estimate);
    }

    private static class SelectorCacheKey {
        private final ComponentSelector componentSelector;
        private final boolean ignoreVersion;
        private final boolean virtualPlatformEdge;

        private SelectorCacheKey(ComponentSelector componentSelector, boolean ignoreVersion, boolean virtualPlatformEdge) {
            this.componentSelector = componentSelector;
            this.ignoreVersion = ignoreVersion;
            this.virtualPlatformEdge = virtualPlatformEdge;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectorCacheKey that = (SelectorCacheKey)o;
            return this.ignoreVersion == that.ignoreVersion && this.virtualPlatformEdge == that.virtualPlatformEdge && this.componentSelector.equals(that.componentSelector);
        }

        public int hashCode() {
            return Objects.hash(this.componentSelector, this.ignoreVersion, this.virtualPlatformEdge);
        }
    }
}

