/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install.exceptions;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.install.exceptions.ToolchainProvisioningException;

@Contextual
public class ToolchainDownloadException
extends GradleException
implements ResolutionProvider {
    private final List<String> resolutions;

    public ToolchainDownloadException(JavaToolchainSpec spec, String url, @Nullable String cause) {
        super(ToolchainDownloadException.getMessage(spec, url, cause));
        this.resolutions = Arrays.asList(ToolchainProvisioningException.AUTO_DETECTION_RESOLUTION, ToolchainProvisioningException.DOWNLOAD_REPOSITORIES_RESOLUTION);
    }

    public ToolchainDownloadException(JavaToolchainSpec spec, URI uri, Throwable cause) {
        super(ToolchainDownloadException.getMessage(spec, uri.toString(), cause.getMessage()), cause);
        this.resolutions = Collections.emptyList();
    }

    public List<String> getResolutions() {
        return this.resolutions;
    }

    @Nonnull
    private static String getMessage(JavaToolchainSpec spec, String url, @Nullable String cause) {
        return "Unable to download toolchain matching the requirements (" + spec.getDisplayName() + ") from '" + url + "'" + (cause != null && !cause.isEmpty() ? ", due to: " + cause : ".");
    }
}

