/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.configuration.problems;

import com.google.common.base.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.code.UserCodeSource;
import org.gradle.internal.configuration.problems.DefaultProblemFactory;
import org.gradle.internal.configuration.problems.DocumentationSection;
import org.gradle.internal.configuration.problems.ProblemFactory;
import org.gradle.internal.configuration.problems.PropertyProblem;
import org.gradle.internal.configuration.problems.PropertyTrace;
import org.gradle.internal.configuration.problems.StructuredMessage;
import org.gradle.internal.extensions.stdlib.CharSequenceExtensionsKt;
import org.gradle.internal.problems.NoOpProblemDiagnosticsFactory;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemDiagnosticsFactory;
import org.gradle.problems.buildtree.ProblemStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0002J+\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\b\u001cH\u0016J,\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gradle/internal/configuration/problems/DefaultProblemFactory;", "Lorg/gradle/internal/configuration/problems/ProblemFactory;", "userCodeContext", "Lorg/gradle/internal/code/UserCodeApplicationContext;", "problemDiagnosticsFactory", "Lorg/gradle/problems/buildtree/ProblemDiagnosticsFactory;", "(Lorg/gradle/internal/code/UserCodeApplicationContext;Lorg/gradle/problems/buildtree/ProblemDiagnosticsFactory;)V", "problemStream", "Lorg/gradle/problems/buildtree/ProblemStream;", "getProblemDiagnostics", "Lorg/gradle/problems/ProblemDiagnostics;", "exception", "", "getStackTrace", "", "locationForCaller", "Lorg/gradle/internal/configuration/problems/PropertyTrace;", "consumer", "", "source", "Lorg/gradle/internal/code/UserCodeSource;", "diagnostics", "problem", "Lorg/gradle/internal/configuration/problems/ProblemFactory$Builder;", "messageBuilder", "Lkotlin/Function1;", "Lorg/gradle/internal/configuration/problems/StructuredMessage$Builder;", "", "Lkotlin/ExtensionFunctionType;", "Lorg/gradle/internal/configuration/problems/PropertyProblem;", "message", "Lorg/gradle/internal/configuration/problems/StructuredMessage;", "documentationSection", "Lorg/gradle/internal/configuration/problems/DocumentationSection;", "configuration-problems-base"})
public final class DefaultProblemFactory
implements ProblemFactory {
    @NotNull
    private final UserCodeApplicationContext userCodeContext;
    @NotNull
    private final ProblemStream problemStream;

    public DefaultProblemFactory(@NotNull UserCodeApplicationContext userCodeContext, @NotNull ProblemDiagnosticsFactory problemDiagnosticsFactory) {
        Intrinsics.checkNotNullParameter((Object)userCodeContext, (String)"userCodeContext");
        Intrinsics.checkNotNullParameter((Object)problemDiagnosticsFactory, (String)"problemDiagnosticsFactory");
        this.userCodeContext = userCodeContext;
        ProblemStream problemStream = problemDiagnosticsFactory.newStream();
        Intrinsics.checkNotNullExpressionValue((Object)problemStream, (String)"problemDiagnosticsFactory.newStream()");
        this.problemStream = problemStream;
    }

    @Override
    @NotNull
    public PropertyTrace locationForCaller(@Nullable String consumer) {
        UserCodeApplicationContext.Application application = this.userCodeContext.current();
        return this.locationForCaller(consumer, (UserCodeSource)(application != null ? application.getSource() : null));
    }

    @Override
    @NotNull
    public PropertyProblem problem(@NotNull StructuredMessage message, @Nullable Throwable exception, @Nullable DocumentationSection documentationSection, boolean getStackTrace) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ProblemDiagnostics diagnostics2 = this.getProblemDiagnostics(exception, getStackTrace);
        PropertyTrace trace = this.locationForCaller(null, diagnostics2);
        return new PropertyProblem(trace, message, exception, diagnostics2.getFailure(), documentationSection);
    }

    private final ProblemDiagnostics getProblemDiagnostics(Throwable exception, boolean getStackTrace) {
        if (getStackTrace) {
            ProblemDiagnostics problemDiagnostics = this.problemStream.forCurrentCaller(exception);
            Intrinsics.checkNotNullExpressionValue((Object)problemDiagnostics, (String)"problemStream.forCurrentCaller(exception)");
            return problemDiagnostics;
        }
        ProblemDiagnostics problemDiagnostics = NoOpProblemDiagnosticsFactory.EMPTY_DIAGNOSTICS;
        Intrinsics.checkNotNullExpressionValue((Object)problemDiagnostics, (String)"EMPTY_DIAGNOSTICS");
        return problemDiagnostics;
    }

    @Override
    @NotNull
    public ProblemFactory.Builder problem(@Nullable String consumer, @NotNull Function1<? super StructuredMessage.Builder, Unit> messageBuilder) {
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        StructuredMessage message = StructuredMessage.Companion.build(messageBuilder);
        return new ProblemFactory.Builder(message, this, consumer){
            private String exceptionMessage;
            private DocumentationSection documentationSection;
            private Function1<? super PropertyTrace, ? extends PropertyTrace> locationMapper;
            final /* synthetic */ StructuredMessage $message;
            final /* synthetic */ DefaultProblemFactory this$0;
            final /* synthetic */ String $consumer;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                this.$consumer = $consumer;
                this.locationMapper = problem.locationMapper.1.INSTANCE;
            }

            public final String getExceptionMessage() {
                return this.exceptionMessage;
            }

            public final void setExceptionMessage(String string) {
                this.exceptionMessage = string;
            }

            public final DocumentationSection getDocumentationSection() {
                return this.documentationSection;
            }

            public final void setDocumentationSection(DocumentationSection documentationSection) {
                this.documentationSection = documentationSection;
            }

            public final Function1<PropertyTrace, PropertyTrace> getLocationMapper() {
                return this.locationMapper;
            }

            public final void setLocationMapper(Function1<? super PropertyTrace, ? extends PropertyTrace> function1) {
                Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
                this.locationMapper = function1;
            }

            public ProblemFactory.Builder exception(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.exceptionMessage = message;
                return this;
            }

            public ProblemFactory.Builder exception() {
                this.exceptionMessage = CharSequenceExtensionsKt.capitalized((CharSequence)this.$message.toString());
                return this;
            }

            public ProblemFactory.Builder exception(Function1<? super String, String> builder) {
                Intrinsics.checkNotNullParameter(builder, (String)"builder");
                this.exceptionMessage = (String)builder.invoke((Object)CharSequenceExtensionsKt.capitalized((CharSequence)this.$message.toString()));
                return this;
            }

            public ProblemFactory.Builder mapLocation(Function1<? super PropertyTrace, ? extends PropertyTrace> mapper) {
                Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
                this.locationMapper = mapper;
                return this;
            }

            public ProblemFactory.Builder documentationSection(DocumentationSection documentationSection) {
                Intrinsics.checkNotNullParameter((Object)((Object)documentationSection), (String)"documentationSection");
                this.documentationSection = documentationSection;
                return this;
            }

            public PropertyProblem build() {
                String exceptionMessage = this.exceptionMessage;
                ProblemDiagnostics problemDiagnostics = exceptionMessage == null ? DefaultProblemFactory.access$getProblemStream$p(this.this$0).forCurrentCaller() : DefaultProblemFactory.access$getProblemStream$p(this.this$0).forCurrentCaller(new Supplier(exceptionMessage){
                    final /* synthetic */ String $exceptionMessage;
                    {
                        this.$exceptionMessage = $exceptionMessage;
                    }

                    public final InvalidUserCodeException get() {
                        return new InvalidUserCodeException(this.$exceptionMessage);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)problemDiagnostics, (String)"exceptionMessage = excep\u2026age) })\n                }");
                ProblemDiagnostics diagnostics2 = problemDiagnostics;
                PropertyTrace location = (PropertyTrace)this.locationMapper.invoke((Object)DefaultProblemFactory.access$locationForCaller(this.this$0, this.$consumer, diagnostics2));
                return new PropertyProblem(location, this.$message, diagnostics2.getException(), diagnostics2.getFailure(), this.documentationSection);
            }
        };
    }

    private final PropertyTrace locationForCaller(String consumer, ProblemDiagnostics diagnostics2) {
        Location location = diagnostics2.getLocation();
        return location != null ? (PropertyTrace)new PropertyTrace.BuildLogic(location) : this.locationForCaller(consumer, diagnostics2.getSource());
    }

    private final PropertyTrace locationForCaller(String consumer, UserCodeSource source) {
        return source != null ? (PropertyTrace)new PropertyTrace.BuildLogic(source) : (consumer != null ? (PropertyTrace)new PropertyTrace.BuildLogicClass(consumer) : (PropertyTrace)PropertyTrace.Unknown.INSTANCE);
    }

    public static final /* synthetic */ ProblemStream access$getProblemStream$p(DefaultProblemFactory $this) {
        return $this.problemStream;
    }

    public static final /* synthetic */ PropertyTrace access$locationForCaller(DefaultProblemFactory $this, String consumer, ProblemDiagnostics diagnostics2) {
        return $this.locationForCaller(consumer, diagnostics2);
    }
}

