/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.AbstractClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;

public class ImmutableClassLoaderScope
extends AbstractClassLoaderScope {
    private final ClassLoaderScope parent;
    private final ClassPath classPath;
    @Nullable
    private final HashCode classpathImplementationHash;
    private final ClassLoader localClassLoader;

    public ImmutableClassLoaderScope(ClassLoaderScopeIdentifier id, ClassLoaderScope parent, @Nullable ClassLoaderScopeOrigin origin, ClassPath classPath, @Nullable HashCode classpathImplementationHash, @Nullable Function<ClassLoader, ClassLoader> localClassLoaderFactory, ClassLoaderCache classLoaderCache, ClassLoaderScopeRegistryListener listener) {
        super(id, origin, classLoaderCache, listener);
        this.parent = parent;
        this.classPath = classPath;
        this.classpathImplementationHash = classpathImplementationHash;
        listener.childScopeCreated(parent.getId(), id, origin);
        ClassLoaderId classLoaderId = id.localId();
        this.localClassLoader = localClassLoaderFactory != null ? classLoaderCache.createIfAbsent(classLoaderId, classPath, parent.getExportClassLoader(), localClassLoaderFactory, classpathImplementationHash) : classLoaderCache.get(classLoaderId, classPath, parent.getExportClassLoader(), null, classpathImplementationHash);
        listener.classloaderCreated(id, classLoaderId, this.localClassLoader, classPath, classpathImplementationHash);
    }

    @Override
    public ClassLoaderScope getParent() {
        return this.parent;
    }

    @Override
    public ClassLoader getExportClassLoader() {
        return this.parent.getExportClassLoader();
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        return this.localClassLoader;
    }

    @Override
    public boolean defines(Class<?> clazz) {
        return this.localClassLoader.equals(clazz.getClassLoader());
    }

    @Override
    public void onReuse() {
        this.parent.onReuse();
        this.listener.childScopeCreated(this.parent.getId(), this.id, this.origin);
        this.listener.classloaderCreated(this.id, this.id.localId(), this.localClassLoader, this.classPath, this.classpathImplementationHash);
    }

    @Override
    public ClassLoaderScope lock() {
        return this;
    }

    @Override
    public boolean isLocked() {
        return true;
    }
}

