/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import groovy.json.JsonBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.reporting.dependencies.internal.StrictDependencyResultSpec;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.internal.Actions;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.CollectionUtils;

class JsonProjectDependencyRenderer {
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;

    public JsonProjectDependencyRenderer(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser) {
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    public String render(ProjectDetails.ProjectNameAndPath project, Iterable<ConfigurationDetails> configurations) {
        JsonBuilder json = new JsonBuilder();
        this.renderProject(project, configurations, json);
        return json.toString();
    }

    private void renderProject(ProjectDetails.ProjectNameAndPath project, Iterable<ConfigurationDetails> configurations, JsonBuilder json) {
        LinkedHashMap<String, Object> overall = new LinkedHashMap<String, Object>();
        overall.put("gradleVersion", GradleVersion.current().toString());
        overall.put("generationDate", new Date().toString());
        LinkedHashMap<String, Object> projectOut = new LinkedHashMap<String, Object>();
        projectOut.put("name", project.getName());
        projectOut.put("description", project.getDescription());
        projectOut.put("configurations", this.createConfigurations(configurations));
        overall.put("project", projectOut);
        json.call(overall);
    }

    private List<Map<String, Object>> createConfigurations(Iterable<ConfigurationDetails> configurations) {
        return CollectionUtils.collect(configurations, configuration -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(4);
            map.put("name", configuration.getName());
            map.put("description", configuration.getDescription());
            map.put("dependencies", this.createDependencies((ConfigurationDetails)configuration));
            map.put("moduleInsights", this.createModuleInsights((ConfigurationDetails)configuration));
            return map;
        });
    }

    private List<Map<String, Object>> createDependencies(ConfigurationDetails configuration) {
        if (configuration.isCanBeResolved()) {
            RenderableModuleResult root = new RenderableModuleResult((ResolvedComponentResult)configuration.getResolutionResultRoot().get());
            return this.createDependencyChildren(root, new HashSet<Object>());
        }
        return this.createDependencyChildren(configuration.getUnresolvableResult(), new HashSet<Object>());
    }

    private List<Map<String, Object>> createDependencyChildren(RenderableDependency dependency, Set<Object> visited) {
        Set<? extends RenderableDependency> children = dependency.getChildren();
        return CollectionUtils.collect(children, childDependency -> {
            boolean alreadyVisited = !visited.add(childDependency.getId());
            boolean alreadyRendered = alreadyVisited && !childDependency.getChildren().isEmpty();
            String name = this.replaceArrow(childDependency.getName());
            boolean hasConflict = !name.equals(childDependency.getName());
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(6);
            ModuleIdentifier moduleIdentifier = this.getModuleIdentifier((RenderableDependency)childDependency);
            map.put("module", moduleIdentifier == null ? null : moduleIdentifier.toString());
            map.put("name", name);
            map.put("resolvable", (Object)childDependency.getResolutionState());
            map.put("hasConflict", hasConflict);
            map.put("alreadyRendered", alreadyRendered);
            map.put("children", Collections.emptyList());
            if (!alreadyRendered) {
                map.put("children", this.createDependencyChildren((RenderableDependency)childDependency, visited));
            }
            return map;
        });
    }

    @Nullable
    private ModuleIdentifier getModuleIdentifier(RenderableDependency renderableDependency) {
        if (renderableDependency.getId() instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier id = (ModuleComponentIdentifier)renderableDependency.getId();
            return id.getModuleIdentifier();
        }
        return null;
    }

    private List<Object> createModuleInsights(ConfigurationDetails configuration) {
        Set<ModuleIdentifier> modules = this.collectModules(configuration);
        return CollectionUtils.collect(modules, moduleIdentifier -> this.createModuleInsight((ModuleIdentifier)moduleIdentifier, configuration));
    }

    private Set<ModuleIdentifier> collectModules(ConfigurationDetails configuration) {
        AbstractRenderableDependency root = configuration.isCanBeResolved() ? new RenderableModuleResult((ResolvedComponentResult)configuration.getResolutionResultRoot().get()) : configuration.getUnresolvableResult();
        HashSet<ModuleIdentifier> modules = new HashSet<ModuleIdentifier>();
        HashSet<ComponentIdentifier> visited = new HashSet<ComponentIdentifier>();
        this.populateModulesWithChildDependencies(root, visited, modules);
        return modules;
    }

    private void populateModulesWithChildDependencies(RenderableDependency dependency, Set<ComponentIdentifier> visited, Set<ModuleIdentifier> modules) {
        for (RenderableDependency renderableDependency : dependency.getChildren()) {
            ModuleIdentifier moduleId = this.getModuleIdentifier(renderableDependency);
            if (moduleId == null) continue;
            modules.add(moduleId);
            boolean alreadyVisited = !visited.add((ComponentIdentifier)renderableDependency.getId());
            if (alreadyVisited) continue;
            this.populateModulesWithChildDependencies(renderableDependency, visited, modules);
        }
    }

    private Map<String, Object> createModuleInsight(ModuleIdentifier module, ConfigurationDetails configuration) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        map.put("module", module.toString());
        map.put("insight", this.createInsight(module, configuration.getName(), (ResolvedComponentResult)configuration.getResolutionResultRoot().get()));
        return map;
    }

    private List<Object> createInsight(ModuleIdentifier module, String configurationName, ResolvedComponentResult incomingResolution) {
        StrictDependencyResultSpec dependencySpec = new StrictDependencyResultSpec(module);
        LinkedHashSet<DependencyResult> selectedDependencies = new LinkedHashSet<DependencyResult>();
        DefaultResolvedComponentResult.eachElement((ResolvedComponentResult)incomingResolution, (Action)Actions.doNothing(), it -> {
            if (dependencySpec.isSatisfiedBy(it)) {
                selectedDependencies.add((DependencyResult)it);
            }
        }, new HashSet());
        Collection<RenderableDependency> sortedDeps = new DependencyInsightReporter(this.versionSelectorScheme, this.versionComparator, this.versionParser).convertToRenderableItems(selectedDependencies, false);
        return CollectionUtils.collect(sortedDeps, dependency -> {
            String name = this.replaceArrow(dependency.getName());
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(5);
            map.put("name", this.replaceArrow(dependency.getName()));
            map.put("description", dependency.getDescription());
            map.put("resolvable", (Object)dependency.getResolutionState());
            map.put("hasConflict", !name.equals(dependency.getName()));
            map.put("children", this.createInsightDependencyChildren((RenderableDependency)dependency, (Set<Object>)new HashSet<Object>(), configurationName));
            return map;
        });
    }

    private List<Object> createInsightDependencyChildren(RenderableDependency dependency, Set<Object> visited, String configurationName) {
        Set<? extends RenderableDependency> children = dependency.getChildren();
        return CollectionUtils.collect(children, childDependency -> {
            boolean alreadyVisited = !visited.add(childDependency.getId());
            boolean leaf = childDependency.getChildren().isEmpty();
            boolean alreadyRendered = alreadyVisited && !leaf;
            String childName = this.replaceArrow(childDependency.getName());
            boolean hasConflict = !childName.equals(childDependency.getName());
            String name = leaf ? configurationName : childName;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(6);
            map.put("name", name);
            map.put("resolvable", (Object)childDependency.getResolutionState());
            map.put("hasConflict", hasConflict);
            map.put("alreadyRendered", alreadyRendered);
            map.put("isLeaf", leaf);
            map.put("children", Collections.emptyList());
            if (!alreadyRendered) {
                map.put("children", this.createInsightDependencyChildren((RenderableDependency)childDependency, visited, configurationName));
            }
            return map;
        });
    }

    private String replaceArrow(String name) {
        return name.replace(" -> ", " \u27a1 ");
    }
}

