/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildoption.DefaultInternalOptions;
import org.gradle.internal.buildoption.InternalFlag;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildoption.StringInternalOption;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.trace.BuildOperationRecord;
import org.gradle.internal.operations.trace.BuildOperationTree;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.operations.trace.SerializedOperation;
import org.gradle.internal.operations.trace.SerializedOperationFinish;
import org.gradle.internal.operations.trace.SerializedOperationProgress;
import org.gradle.internal.operations.trace.SerializedOperationStart;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.GFileUtils;

@ServiceScope(value={Scope.CrossBuildSession.class})
public class BuildOperationTrace
implements Stoppable {
    public static final String SYSPROP = "org.gradle.internal.operations.trace";
    private static final StringInternalOption TRACE_OPTION = new StringInternalOption("org.gradle.internal.operations.trace", null);
    public static final String FILTER_SYSPROP = "org.gradle.internal.operations.trace.filter";
    private static final StringInternalOption FILTER_OPTION = new StringInternalOption("org.gradle.internal.operations.trace.filter", null);
    public static final String TREE_SYSPROP = "org.gradle.internal.operations.trace.tree";
    private static final InternalFlag TRACE_TREE_OPTION = new InternalFlag("org.gradle.internal.operations.trace.tree", true);
    public static final String FILTER_SEPARATOR = ";";
    private static final byte[] NEWLINE = new byte[]{10};
    private final boolean outputTree;
    private final BuildOperationListener listener;
    private final String basePath;
    private final OutputStream logOutputStream;
    private final ObjectMapper objectMapper;
    private final BuildOperationListenerManager buildOperationListenerManager;

    public BuildOperationTrace(StartParameter startParameter, BuildOperationListenerManager buildOperationListenerManager) {
        this.buildOperationListenerManager = buildOperationListenerManager;
        DefaultInternalOptions internalOptions = new DefaultInternalOptions(startParameter.getSystemPropertiesArgs());
        this.basePath = (String)internalOptions.getOption((InternalOption)TRACE_OPTION).get();
        if (this.basePath == null || this.basePath.equals(Boolean.FALSE.toString())) {
            this.logOutputStream = null;
            this.outputTree = false;
            this.listener = null;
            this.objectMapper = null;
            return;
        }
        this.objectMapper = BuildOperationTrace.createObjectMapper();
        Set<String> filter = BuildOperationTrace.getFilter((InternalOptions)internalOptions);
        if (filter != null) {
            this.outputTree = false;
            this.listener = new FilteringBuildOperationListener(new SerializingBuildOperationListener(this::write), filter);
        } else {
            this.outputTree = (Boolean)internalOptions.getOption((InternalOption)TRACE_TREE_OPTION).get();
            this.listener = new SerializingBuildOperationListener(this::write);
        }
        try {
            File logFile = BuildOperationTrace.logFile(this.basePath);
            GFileUtils.mkdirs((File)logFile.getParentFile());
            if (logFile.isFile()) {
                GFileUtils.forceDelete((File)logFile);
            }
            logFile.createNewFile();
            this.logOutputStream = new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        buildOperationListenerManager.addListener(this.listener);
    }

    @Nullable
    private static Set<String> getFilter(InternalOptions internalOptions) {
        String filterProperty = (String)internalOptions.getOption((InternalOption)FILTER_OPTION).get();
        if (filterProperty == null) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(filterProperty.split(FILTER_SEPARATOR)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.buildOperationListenerManager.removeListener(this.listener);
        if (this.logOutputStream != null) {
            try {
                OutputStream outputStream = this.logOutputStream;
                synchronized (outputStream) {
                    this.logOutputStream.close();
                }
                if (this.outputTree) {
                    List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(BuildOperationTrace.logFile(this.basePath), false);
                    this.writeDetailTree(roots);
                    this.writeSummaryTree(roots);
                }
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SerializedOperation operation) {
        try {
            String json = this.objectMapper.writeValueAsString(operation.toMap());
            OutputStream outputStream = this.logOutputStream;
            synchronized (outputStream) {
                this.logOutputStream.write(json.getBytes(StandardCharsets.UTF_8));
                this.logOutputStream.write(NEWLINE);
                this.logOutputStream.flush();
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void writeDetailTree(List<BuildOperationRecord> roots) throws IOException {
        File outputFile = BuildOperationTrace.file(this.basePath, "-tree.json");
        this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, BuildOperationTree.serialize(roots));
    }

    private void writeSummaryTree(List<BuildOperationRecord> roots) throws IOException {
        Path outputPath = Paths.get(this.basePath + "-tree.txt", new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            ArrayDeque<ArrayDeque<BuildOperationRecord>> stack = new ArrayDeque<ArrayDeque<BuildOperationRecord>>(Collections.singleton(new ArrayDeque<BuildOperationRecord>(roots)));
            StringBuilder stringBuilder = new StringBuilder();
            while (!stack.isEmpty()) {
                if (((Queue)stack.peek()).isEmpty()) {
                    stack.pop();
                    continue;
                }
                Queue children = (Queue)stack.element();
                BuildOperationRecord record = (BuildOperationRecord)children.remove();
                stringBuilder.setLength(0);
                int indents = stack.size() - 1;
                for (int i = 0; i < indents; ++i) {
                    stringBuilder.append("  ");
                }
                if (!record.children.isEmpty()) {
                    stack.addFirst(new ArrayDeque<BuildOperationRecord>(record.children));
                }
                stringBuilder.append(record.displayName);
                if (record.details != null) {
                    stringBuilder.append(" ");
                    try {
                        stringBuilder.append(this.objectMapper.writeValueAsString(record.details));
                    }
                    catch (JsonProcessingException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                if (record.result != null) {
                    stringBuilder.append(" ");
                    try {
                        stringBuilder.append(this.objectMapper.writeValueAsString(record.result));
                    }
                    catch (JsonProcessingException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                stringBuilder.append(" [");
                stringBuilder.append(record.endTime - record.startTime);
                stringBuilder.append("ms]");
                stringBuilder.append(" (");
                stringBuilder.append(record.id);
                stringBuilder.append(")");
                if (!record.progress.isEmpty()) {
                    for (BuildOperationRecord.Progress progress : record.progress) {
                        stringBuilder.append(System.lineSeparator());
                        for (int i = 0; i < indents; ++i) {
                            stringBuilder.append("  ");
                        }
                        stringBuilder.append("- ").append(progress.details).append(" [").append(progress.time - record.startTime).append("]");
                    }
                }
                writer.write(stringBuilder.toString());
                writer.newLine();
            }
        }
    }

    public static BuildOperationTree read(String basePath) {
        File logFile = BuildOperationTrace.logFile(basePath);
        List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(logFile, true);
        return new BuildOperationTree(roots);
    }

    public static BuildOperationTree readPartialTree(String basePath) {
        File logFile = BuildOperationTrace.logFile(basePath);
        List<BuildOperationRecord> partialTree = BuildOperationTrace.readLogToTreeRoots(logFile, false);
        return new BuildOperationTree(partialTree);
    }

    private static List<BuildOperationRecord> readLogToTreeRoots(File logFile, boolean completeTree) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayList<BuildOperationRecord> roots = new ArrayList<BuildOperationRecord>();
            HashMap pendings = new HashMap();
            HashMap childrens = new HashMap();
            ArrayList<SerializedOperationProgress> danglingProgress = new ArrayList<SerializedOperationProgress>();
            try (Stream<String> lines = Files.lines(logFile.toPath());){
                lines.forEach(line -> {
                    Map map;
                    try {
                        map = (Map)objectMapper.readValue(line, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    }
                    catch (JsonProcessingException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                    if (map.containsKey("startTime")) {
                        SerializedOperationStart serialized = new SerializedOperationStart(map);
                        pendings.put(serialized.id, new PendingOperation(serialized));
                        childrens.put(serialized.id, new LinkedList());
                    } else if (map.containsKey("time")) {
                        SerializedOperationProgress serialized = new SerializedOperationProgress(map);
                        PendingOperation pending = (PendingOperation)pendings.get(serialized.id);
                        if (pending != null) {
                            pending.progress.add(serialized);
                        } else {
                            if (completeTree) {
                                throw new IllegalStateException("did not find owner of progress event with ID " + serialized.id);
                            }
                            danglingProgress.add(serialized);
                        }
                    } else {
                        SerializedOperationFinish finish = new SerializedOperationFinish(map);
                        PendingOperation pending = (PendingOperation)pendings.remove(finish.id);
                        assert (pending != null);
                        List children = (List)childrens.remove(finish.id);
                        assert (children != null);
                        SerializedOperationStart start = pending.start;
                        Map detailsMap = (Map)Cast.uncheckedCast((Object)start.details);
                        Map resultMap = (Map)Cast.uncheckedCast((Object)finish.result);
                        BuildOperationRecord record = new BuildOperationRecord(start.id, start.parentId, start.displayName, start.startTime, finish.endTime, detailsMap == null ? null : Collections.unmodifiableMap(detailsMap), start.detailsClassName, resultMap == null ? null : Collections.unmodifiableMap(resultMap), finish.resultClassName, finish.failureMsg, pending.progress, (List<BuildOperationRecord>)BuildOperationRecord.ORDERING.immutableSortedCopy((Iterable)children));
                        if (start.parentId == null) {
                            roots.add(record);
                        } else {
                            List parentChildren = (List)childrens.get(start.parentId);
                            if (parentChildren != null) {
                                parentChildren.add(record);
                            } else {
                                if (completeTree) {
                                    throw new IllegalStateException("parentChildren != null '" + line + "' from " + logFile);
                                }
                                roots.add(record);
                            }
                        }
                    }
                });
            }
            assert (pendings.isEmpty());
            if (!completeTree && !danglingProgress.isEmpty()) {
                roots.add(new BuildOperationRecord(-1L, null, "Dangling pending operations", 0L, 0L, null, null, null, null, null, danglingProgress, Collections.emptyList()));
            }
            return roots;
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static File logFile(String basePath) {
        return BuildOperationTrace.file(basePath, "-log.txt");
    }

    private static File file(@Nullable String base, String suffix) {
        return new File((base == null || base.trim().isEmpty() ? "operations" : base) + suffix).getAbsoluteFile();
    }

    @Nullable
    public static Object toSerializableModel(@Nullable Object object) {
        if (object instanceof CustomOperationTraceSerialization) {
            return ((CustomOperationTraceSerialization)object).getCustomOperationTraceSerializableModel();
        }
        return object;
    }

    private static ObjectMapper createObjectMapper() {
        return new ObjectMapper().registerModule((Module)new SimpleModule().addSerializer(Class.class, (JsonSerializer)new JsonClassSerializer()).addSerializer(Throwable.class, (JsonSerializer)new JsonThrowableSerializer()).addSerializer(AttributeContainer.class, (JsonSerializer)new JsonAttributeContainerSerializer()).setSerializerModifier((BeanSerializerModifier)new SkipDeprecatedBeanSerializerModifier())).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    private static class FilteringBuildOperationListener
    implements BuildOperationListener {
        private final BuildOperationListener delegate;
        private final Set<String> filter;

        public FilteringBuildOperationListener(BuildOperationListener delegate, Set<String> filter) {
            this.delegate = delegate;
            this.filter = filter;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            if (buildOperation.getDetails() != null && this.filter.contains(buildOperation.getDetails().getClass().getName())) {
                this.delegate.started(buildOperation, startEvent);
            }
        }

        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
            if (progressEvent.getDetails() != null && this.filter.contains(progressEvent.getDetails().getClass().getName())) {
                this.delegate.progress(operationIdentifier, progressEvent);
            }
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            if (buildOperation.getDetails() != null && this.filter.contains(buildOperation.getDetails().getClass().getName()) || finishEvent.getResult() != null && this.filter.contains(finishEvent.getResult().getClass().getName())) {
                this.delegate.finished(buildOperation, finishEvent);
            }
        }
    }

    private static class SerializingBuildOperationListener
    implements BuildOperationListener {
        private final Consumer<SerializedOperation> consumer;

        public SerializingBuildOperationListener(Consumer<SerializedOperation> consumer) {
            this.consumer = consumer;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            this.consumer.accept(new SerializedOperationStart(buildOperation, startEvent));
        }

        public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
            this.consumer.accept(new SerializedOperationProgress(buildOperationId, progressEvent));
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            this.consumer.accept(new SerializedOperationFinish(buildOperation, finishEvent));
        }
    }

    private static class JsonClassSerializer
    extends JsonSerializer<Class> {
        private JsonClassSerializer() {
        }

        public void serialize(Class aClass, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(aClass.getName());
        }
    }

    private static class JsonThrowableSerializer
    extends JsonSerializer<Throwable> {
        private JsonThrowableSerializer() {
        }

        public void serialize(Throwable throwable, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            String message = throwable.getMessage();
            if (message != null) {
                gen.writeStringField("message", message);
            }
            gen.writeStringField("stackTrace", Throwables.getStackTraceAsString((Throwable)throwable));
            gen.writeEndObject();
        }
    }

    private static class JsonAttributeContainerSerializer
    extends JsonSerializer<AttributeContainer> {
        private JsonAttributeContainerSerializer() {
        }

        public void serialize(AttributeContainer attributeContainer, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Attribute attribute : attributeContainer.keySet()) {
                builder.put((Object)attribute, Cast.uncheckedCast((Object)Objects.requireNonNull(attributeContainer.getAttribute(attribute))));
            }
            serializers.defaultSerializeValue((Object)builder.build(), gen);
        }
    }

    private static class SkipDeprecatedBeanSerializerModifier
    extends BeanSerializerModifier {
        private SkipDeprecatedBeanSerializerModifier() {
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            beanProperties.removeIf(writer -> {
                AnnotatedMember member = writer.getMember();
                return member != null && member.hasAnnotation(Deprecated.class);
            });
            return beanProperties;
        }
    }

    static class PendingOperation {
        final SerializedOperationStart start;
        final List<SerializedOperationProgress> progress = new ArrayList<SerializedOperationProgress>();

        PendingOperation(SerializedOperationStart start) {
            this.start = start;
        }
    }
}

