/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.userdefined;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class NormalizeArrayFunction
implements Function {
    public String getCanonicalName() {
        return "NORMALIZEARRAY";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Sequence sequence = context.getTypeRegistry().convertToSequence(parameters.getType(0), parameters.getValue(0));
        if (sequence == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        ArrayList<Object> retval = new ArrayList<Object>();
        while (sequence.hasNext()) {
            Object o = sequence.next();
            if (o == null) continue;
            retval.add(o);
        }
        return new TypeValuePair(AnyType.ANY_ARRAY, retval.toArray());
    }
}

