#ifndef XML_PARSER_H
#define XML_PARSER_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

#include "global.h"
#include "Player.h"
#include "Team.h"
#include "State.h"
#include "Config.h"

Team* xml_load_team(const char*,int);
int xml_save_team(Team*,const char*);

team_summary_t* xml_load_team_summary(char*);

State* xml_load_game(const char*);
int xml_save_game(State*, const char*);

config_data_t* xml_load_config(const char*);
int xml_save_config(config_data_t*, const char*);

void xml_load_formation(const char*);

#endif

