/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildInitDependency;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.model.Description;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class JvmApplicationProjectInitDescriptor
extends JvmProjectInitDescriptor {
    public JvmApplicationProjectInitDescriptor(Description description, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(description, libraryVersionProvider, documentationRegistry);
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.APPLICATION;
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return new TreeSet<ModularizationOption>(Arrays.asList(ModularizationOption.SINGLE_PROJECT, ModularizationOption.WITH_LIBRARY_PROJECTS));
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generateProjectBuildScript(projectName, settings, buildScriptBuilder);
        if ("app".equals(projectName)) {
            buildScriptBuilder.block(null, "application", (Action<? super ScriptBlockBuilder>)((Action)b -> {
                String mainClass;
                String string = mainClass = this.getLanguage() == Language.KOTLIN ? "AppKt" : "App";
                if (!this.isSingleProject(settings)) {
                    mainClass = "app." + mainClass;
                }
                b.propertyAssignment("Define the main class for the application.", "mainClass", this.withPackage(settings, mainClass), false);
            }));
        }
        if (this.isSingleProject(settings)) {
            this.applyApplicationPlugin(buildScriptBuilder);
            buildScriptBuilder.implementationDependency("This dependency is used by the application.", BuildInitDependency.of("com.google.guava:guava", this.libraryVersionProvider.getVersion("guava")));
        } else if ("app".equals(projectName)) {
            buildScriptBuilder.plugin(null, this.applicationConventionPlugin(settings));
            buildScriptBuilder.dependencies().dependency("implementation", null, BuildInitDependency.of("org.apache.commons:commons-text"));
            buildScriptBuilder.dependencies().projectDependency("implementation", null, ":utilities");
        } else {
            buildScriptBuilder.plugin(null, this.libraryConventionPlugin(settings));
            if ("utilities".equals(projectName)) {
                buildScriptBuilder.dependencies().projectDependency("api", null, ":list");
            }
        }
    }

    @Override
    protected List<String> getSourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory) {
        if (this.isSingleProject(settings)) {
            return Lists.newArrayList((Object[])new String[]{"App"});
        }
        switch (subproject) {
            case "app": {
                return Lists.newArrayList((Object[])new String[]{"multi/app/App", "multi/app/MessageUtils"});
            }
            case "list": {
                return Lists.newArrayList((Object[])new String[]{"multi/list/LinkedList"});
            }
            case "utilities": {
                return Lists.newArrayList((Object[])new String[]{"multi/utilities/JoinUtils", "multi/utilities/SplitUtils", "multi/utilities/StringUtils"});
            }
        }
        return new ArrayList<String>();
    }

    @Override
    protected List<String> getTestSourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory) {
        if (this.isSingleProject(settings)) {
            return Lists.newArrayList((Object[])new String[]{JvmApplicationProjectInitDescriptor.getTestFrameWorkName(settings)});
        }
        switch (subproject) {
            case "app": {
                return Lists.newArrayList((Object[])new String[]{"multi/app/junit5/MessageUtilsTest"});
            }
            case "list": {
                return Lists.newArrayList((Object[])new String[]{"multi/list/junit5/LinkedListTest"});
            }
        }
        return new ArrayList<String>();
    }

    private static String getTestFrameWorkName(InitSettings settings) {
        switch (settings.getTestFramework()) {
            case SPOCK: {
                return "groovy/AppTest";
            }
            case TESTNG: {
                return "testng/AppTest";
            }
            case JUNIT: 
            case KOTLINTEST: {
                return "AppTest";
            }
            case JUNIT_JUPITER: {
                return "junitjupiter/AppTest";
            }
            case SCALATEST: {
                return "AppSuite";
            }
        }
        throw new IllegalArgumentException();
    }
}

