/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.IOException;
import java.util.SortedSet;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.gradle.api.internal.changedetection.state.CrossBuildFileHashCache;
import org.gradle.api.specs.Spec;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.VersionSpecificCacheDirectory;
import org.gradle.cache.internal.VersionSpecificCacheDirectoryScanner;
import org.gradle.internal.cache.MonitoredCleanupAction;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionSpecificCacheCleanupAction
implements MonitoredCleanupAction {
    private static final String FILE_HASHES_CACHE_KEY = CrossBuildFileHashCache.Kind.FILE_HASHES.getCacheId();
    @VisibleForTesting
    static final String MARKER_FILE_PATH = FILE_HASHES_CACHE_KEY + "/" + FILE_HASHES_CACHE_KEY + ".lock";
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionSpecificCacheCleanupAction.class);
    private final VersionSpecificCacheDirectoryScanner versionSpecificCacheDirectoryScanner;
    private final Supplier<Long> releaseTimestampSupplier;
    private final Supplier<Long> snapshotTimestampSupplier;
    private final Deleter deleter;
    private final CleanupFrequency cleanupFrequency;

    public VersionSpecificCacheCleanupAction(File cacheBaseDir, Supplier<Long> releasesAndSnapshotTimestampSupplier, Deleter deleter, CleanupFrequency cleanupFrequency) {
        this(cacheBaseDir, releasesAndSnapshotTimestampSupplier, releasesAndSnapshotTimestampSupplier, deleter, cleanupFrequency);
    }

    public VersionSpecificCacheCleanupAction(File cacheBaseDir, Supplier<Long> releaseTimestampSupplier, Supplier<Long> snapshotTimestampSupplier, Deleter deleter, CleanupFrequency cleanupFrequency) {
        this.deleter = deleter;
        Preconditions.checkArgument((releaseTimestampSupplier.get() <= snapshotTimestampSupplier.get() ? 1 : 0) != 0, (String)"release timestamp (%s) must supply a timestamp older than or equal to snapshot timestamp (%s)", (Object)releaseTimestampSupplier.get(), (Object)snapshotTimestampSupplier.get());
        this.versionSpecificCacheDirectoryScanner = new VersionSpecificCacheDirectoryScanner(cacheBaseDir);
        this.releaseTimestampSupplier = releaseTimestampSupplier;
        this.snapshotTimestampSupplier = snapshotTimestampSupplier;
        this.cleanupFrequency = cleanupFrequency;
    }

    @Nonnull
    public String getDisplayName() {
        return "Deleting unused version-specific caches in " + this.versionSpecificCacheDirectoryScanner.getBaseDir();
    }

    public boolean execute(@Nonnull CleanupProgressMonitor progressMonitor) {
        if (this.requiresCleanup()) {
            Timer timer = Time.startTimer();
            this.performCleanup(progressMonitor);
            LOGGER.debug("Processed version-specific caches at {} for cleanup in {}", (Object)this.versionSpecificCacheDirectoryScanner.getBaseDir(), (Object)timer.getElapsed());
            return true;
        }
        return false;
    }

    private boolean requiresCleanup() {
        long lastCleanupTimestamp;
        File gcFile = this.getGcFile();
        if (!gcFile.exists()) {
            if (!gcFile.getParentFile().exists()) {
                return false;
            }
            lastCleanupTimestamp = 0L;
        } else {
            lastCleanupTimestamp = gcFile.lastModified();
        }
        return this.cleanupFrequency.requiresCleanup(lastCleanupTimestamp);
    }

    private void markCleanedUp() {
        GFileUtils.touch((File)this.getGcFile());
    }

    private File getGcFile() {
        File currentVersionCacheDir = this.versionSpecificCacheDirectoryScanner.getDirectory(GradleVersion.current());
        return new File(currentVersionCacheDir, "gc.properties");
    }

    private void performCleanup(CleanupProgressMonitor progressMonitor) {
        SortedSetMultimap<GradleVersion, VersionSpecificCacheDirectory> cacheDirsByBaseVersion = this.scanForVersionSpecificCacheDirs();
        for (GradleVersion baseVersion : cacheDirsByBaseVersion.keySet()) {
            this.performCleanup(cacheDirsByBaseVersion.get((Object)baseVersion), this.releaseTimestampSupplier, this.snapshotTimestampSupplier, progressMonitor);
        }
        this.markCleanedUp();
    }

    private SortedSetMultimap<GradleVersion, VersionSpecificCacheDirectory> scanForVersionSpecificCacheDirs() {
        TreeMultimap cacheDirsByBaseVersion = TreeMultimap.create();
        for (VersionSpecificCacheDirectory cacheDir : this.versionSpecificCacheDirectoryScanner.getExistingDirectories()) {
            cacheDirsByBaseVersion.put((Object)cacheDir.getVersion().getBaseVersion(), (Object)cacheDir);
        }
        return cacheDirsByBaseVersion;
    }

    private void performCleanup(SortedSet<VersionSpecificCacheDirectory> cacheDirsWithSameBaseVersion, Supplier<Long> releaseTimestampSupplier, Supplier<Long> snapshotTimestampSupplier, CleanupProgressMonitor progressMonitor) {
        CleanupCondition cleanupCondition = new CleanupCondition(cacheDirsWithSameBaseVersion, releaseTimestampSupplier, snapshotTimestampSupplier);
        for (VersionSpecificCacheDirectory cacheDir : cacheDirsWithSameBaseVersion) {
            if (cleanupCondition.isSatisfiedBy(cacheDir)) {
                progressMonitor.incrementDeleted();
                try {
                    this.deleteCacheDir(cacheDir.getDir());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to process/clean up version-specific cache directory: {}", (Object)cacheDir.getDir(), (Object)e);
                }
                continue;
            }
            progressMonitor.incrementSkipped();
        }
    }

    private void deleteCacheDir(File cacheDir) throws IOException {
        LOGGER.debug("Deleting version-specific cache directory at {}", (Object)cacheDir);
        this.deleter.deleteRecursively(cacheDir);
    }

    private static class CleanupCondition
    implements Spec<VersionSpecificCacheDirectory> {
        private final SortedSet<VersionSpecificCacheDirectory> cacheDirsWithSameBaseVersion;
        private final Supplier<Long> releaseTimestampSupplier;
        private final Supplier<Long> snapshotTimestampSupplier;

        CleanupCondition(SortedSet<VersionSpecificCacheDirectory> cacheDirsWithSameBaseVersion, Supplier<Long> releaseTimestampSupplier, Supplier<Long> snapshotTimestampSupplier) {
            this.cacheDirsWithSameBaseVersion = cacheDirsWithSameBaseVersion;
            this.releaseTimestampSupplier = releaseTimestampSupplier;
            this.snapshotTimestampSupplier = snapshotTimestampSupplier;
        }

        public boolean isSatisfiedBy(VersionSpecificCacheDirectory cacheDir) {
            if (cacheDir.getVersion().compareTo(GradleVersion.current()) >= 0) {
                return false;
            }
            File markerFile = new File(cacheDir.getDir(), MARKER_FILE_PATH);
            return markerFile.exists() && this.markerFileHasNotBeenTouchedRecently(cacheDir, markerFile);
        }

        private boolean markerFileHasNotBeenTouchedRecently(VersionSpecificCacheDirectory cacheDir, File markerFile) {
            if (markerFile.lastModified() < this.releaseTimestampSupplier.get()) {
                return true;
            }
            if (cacheDir.getVersion().isSnapshot() && markerFile.lastModified() < this.snapshotTimestampSupplier.get()) {
                return this.cacheDirsWithSameBaseVersion.tailSet(cacheDir).size() > 1;
            }
            return false;
        }
    }
}

