/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.plan.DefaultFinalizedExecutionPlan;
import org.gradle.execution.plan.DetermineExecutionPlanAction;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchy;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeComparator;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.OrdinalGroupFactory;
import org.gradle.execution.plan.OrdinalNodeAccess;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.execution.plan.ScheduledWork;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.resources.ResourceLockCoordinationService;

@NonNullApi
public class DefaultExecutionPlan
implements ExecutionPlan,
QueryableExecutionPlan {
    private final Set<Node> entryNodes = new LinkedHashSet<Node>();
    private final NodeMapping nodeMapping = new NodeMapping();
    private final String displayName;
    private final TaskNodeFactory taskNodeFactory;
    private final TaskDependencyResolver dependencyResolver;
    private final ExecutionNodeAccessHierarchy outputHierarchy;
    private final ExecutionNodeAccessHierarchy destroyableHierarchy;
    private final ResourceLockCoordinationService lockCoordinator;
    private Spec<? super Task> filter = Specs.satisfyAll();
    private int order = 0;
    private boolean continueOnFailure;
    private final Set<Node> filteredNodes = Sets.newIdentityHashSet();
    private final Set<Node> finalizers = new LinkedHashSet<Node>();
    private final OrdinalNodeAccess ordinalNodeAccess;
    private Consumer<LocalTaskNode> completionHandler = localTaskNode -> {};
    private DefaultFinalizedExecutionPlan finalizedPlan;
    private ImmutableList<Node> scheduledNodes;

    public DefaultExecutionPlan(String displayName, TaskNodeFactory taskNodeFactory, OrdinalGroupFactory ordinalGroupFactory, TaskDependencyResolver dependencyResolver, ExecutionNodeAccessHierarchy outputHierarchy, ExecutionNodeAccessHierarchy destroyableHierarchy, ResourceLockCoordinationService lockCoordinator) {
        this.displayName = displayName;
        this.taskNodeFactory = taskNodeFactory;
        this.dependencyResolver = dependencyResolver;
        this.outputHierarchy = outputHierarchy;
        this.destroyableHierarchy = destroyableHierarchy;
        this.lockCoordinator = lockCoordinator;
        this.ordinalNodeAccess = new OrdinalNodeAccess(ordinalGroupFactory);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public QueryableExecutionPlan getContents() {
        return this;
    }

    @Override
    public TaskNode getNode(Task task) {
        return this.nodeMapping.get(task);
    }

    @Override
    public void setScheduledWork(ScheduledWork work) {
        if (this.scheduledNodes != null) {
            throw new IllegalStateException("This execution plan already has nodes scheduled.");
        }
        this.scheduledNodes = work.getScheduledNodes();
        this.entryNodes.addAll((Collection<Node>)work.getEntryNodes());
        this.nodeMapping.addAll(this.scheduledNodes);
    }

    @Override
    public void addEntryTask(Task task) {
        this.addEntryTasks(Collections.singletonList(task));
    }

    @Override
    public void addEntryTasks(Collection<? extends Task> tasks) {
        this.addEntryTasks(tasks, this.order++);
    }

    private void addEntryTasks(Collection<? extends Task> tasks, int ordinal) {
        TreeSet<Node> nodes = new TreeSet<Node>(NodeComparator.INSTANCE);
        for (Task task : tasks) {
            nodes.add(this.taskNodeFactory.getOrCreateNode(task));
        }
        this.doAddEntryNodes(nodes, ordinal);
    }

    public void addEntryNodes(Collection<? extends Node> nodes) {
        this.addEntryNodes(nodes, this.order++);
    }

    private void addEntryNodes(Collection<? extends Node> nodes, int ordinal) {
        TreeSet<Node> sorted = new TreeSet<Node>(NodeComparator.INSTANCE);
        sorted.addAll(nodes);
        this.doAddEntryNodes(sorted, ordinal);
    }

    private void doAddEntryNodes(SortedSet<? extends Node> nodes, int ordinal) {
        this.scheduledNodes = null;
        LinkedList<Node> queue = new LinkedList<Node>();
        OrdinalGroup group = this.ordinalNodeAccess.group(ordinal);
        for (Node node : nodes) {
            node.maybeInheritOrdinalAsDependency(group);
            group.addEntryNode(node);
            this.entryNodes.add(node);
            queue.add(node);
        }
        this.discoverNodeRelationships(queue);
    }

    private void discoverNodeRelationships(LinkedList<Node> queue) {
        HashSet<Node> visiting = new HashSet<Node>();
        while (!queue.isEmpty()) {
            boolean filtered;
            Node node = queue.getFirst();
            node.prepareForScheduling();
            if (node.getDependenciesProcessed() || node.isCannotRunInAnyPlan()) {
                queue.removeFirst();
                continue;
            }
            boolean bl = filtered = !this.nodeSatisfiesTaskFilter(node);
            if (filtered) {
                queue.removeFirst();
                node.dependenciesProcessed();
                node.filtered();
                this.filteredNodes.add(node);
                continue;
            }
            node.require();
            if (visiting.add(node)) {
                node.resolveDependencies(this.dependencyResolver);
                for (Node node2 : node.getHardSuccessors()) {
                    node2.maybeInheritOrdinalAsDependency(node.getGroup().asOrdinal());
                }
                ListIterator<Node> insertPoint = queue.listIterator();
                for (Node successor3 : node.getDependencySuccessors()) {
                    if (visiting.contains(successor3)) continue;
                    insertPoint.add(successor3);
                }
                continue;
            }
            queue.removeFirst();
            visiting.remove(node);
            node.dependenciesProcessed();
            for (Node node3 : node.getFinalizers()) {
                this.finalizers.add(node3);
                if (visiting.contains(node3)) continue;
                queue.addFirst(node3);
            }
        }
    }

    private boolean nodeSatisfiesTaskFilter(Node successor) {
        if (successor instanceof LocalTaskNode) {
            return this.filter.isSatisfiedBy((Object)((LocalTaskNode)successor).getTask());
        }
        return true;
    }

    @Override
    public void determineExecutionPlan() {
        if (this.scheduledNodes == null) {
            this.scheduledNodes = new DetermineExecutionPlanAction(this.nodeMapping, this.ordinalNodeAccess, this.entryNodes, this.finalizers).run();
            this.finalizers.clear();
        }
    }

    @Override
    public FinalizedExecutionPlan finalizePlan() {
        if (this.scheduledNodes == null) {
            throw new IllegalStateException("Nodes have node been scheduled yet.");
        }
        if (this.finalizedPlan == null) {
            this.dependencyResolver.clear();
            this.finalizedPlan = new DefaultFinalizedExecutionPlan(this.displayName, this.ordinalNodeAccess, this.outputHierarchy, this.destroyableHierarchy, this.lockCoordinator, (List<Node>)this.scheduledNodes, this.continueOnFailure, this, this.completionHandler);
        }
        return this.finalizedPlan;
    }

    @Override
    public void close() {
        if (this.finalizedPlan != null) {
            this.finalizedPlan.close();
        }
        for (Node node : this.nodeMapping) {
            node.reset();
        }
        for (Node node : this.filteredNodes) {
            node.reset();
        }
        this.completionHandler = localTaskNode -> {};
        this.entryNodes.clear();
        this.nodeMapping.clear();
        this.filteredNodes.clear();
        this.finalizers.clear();
        this.scheduledNodes = null;
        this.ordinalNodeAccess.reset();
        this.dependencyResolver.clear();
    }

    @Override
    public void onComplete(Consumer<LocalTaskNode> handler) {
        Consumer<LocalTaskNode> previous = this.completionHandler;
        this.completionHandler = node -> {
            previous.accept((LocalTaskNode)node);
            handler.accept((LocalTaskNode)node);
        };
    }

    @Override
    public Set<Task> getTasks() {
        return this.nodeMapping.getTasks();
    }

    @Override
    public Set<Task> getRequestedTasks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node entryNode : this.entryNodes) {
            if (!(entryNode instanceof LocalTaskNode)) continue;
            builder.add((Object)((LocalTaskNode)entryNode).getTask());
        }
        return builder.build();
    }

    @Override
    public QueryableExecutionPlan.ScheduledNodes getScheduledNodes() {
        if (this.scheduledNodes == null) {
            throw new IllegalStateException("Nodes have node been scheduled yet.");
        }
        for (Node node : this.scheduledNodes) {
            if (!(node instanceof TaskNode)) continue;
            ((TaskNode)node).getTask();
        }
        return new ScheduledWork((List<? extends Node>)this.scheduledNodes, (Collection<? extends Node>)this.entryNodes);
    }

    @Override
    public Set<Task> getFilteredTasks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node filteredNode : this.filteredNodes) {
            if (!(filteredNode instanceof LocalTaskNode)) continue;
            builder.add((Object)((LocalTaskNode)filteredNode).getTask());
        }
        return builder.build();
    }

    @Override
    public void addFilter(Spec<? super Task> filter) {
        this.filter = Specs.intersect((Spec[])new Spec[]{this.filter, filter});
    }

    @Override
    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    @Override
    public int size() {
        return this.nodeMapping.getNumberOfPublicNodes();
    }

    static class NodeMapping
    extends AbstractCollection<Node> {
        private final Map<Task, LocalTaskNode> taskMapping = Maps.newLinkedHashMap();
        private final Set<Node> nodes = Sets.newLinkedHashSet();

        NodeMapping() {
        }

        @Override
        public boolean contains(Object o) {
            return this.nodes.contains(o);
        }

        @Override
        public boolean add(Node node) {
            if (!this.nodes.add(node)) {
                return false;
            }
            if (node instanceof LocalTaskNode) {
                LocalTaskNode taskNode = (LocalTaskNode)node;
                this.taskMapping.put(taskNode.getTask(), taskNode);
            }
            return true;
        }

        public LocalTaskNode get(Task task) {
            LocalTaskNode taskNode = this.taskMapping.get(task);
            if (taskNode == null) {
                throw new IllegalStateException("Task is not part of the execution plan, no dependency information is available.");
            }
            return taskNode;
        }

        public Set<Task> getTasks() {
            return this.taskMapping.keySet();
        }

        @Override
        public Iterator<Node> iterator() {
            return this.nodes.iterator();
        }

        @Override
        public void clear() {
            this.nodes.clear();
            this.taskMapping.clear();
        }

        @Override
        public int size() {
            return this.nodes.size();
        }

        public int getNumberOfPublicNodes() {
            int publicNodes = 0;
            for (Node node : this) {
                if (!node.isPublicNode()) continue;
                ++publicNodes;
            }
            return publicNodes;
        }

        public void retainFirst(int count) {
            Iterator<Node> executionPlanIterator = this.nodes.iterator();
            for (int i = 0; i < count; ++i) {
                executionPlanIterator.next();
            }
            while (executionPlanIterator.hasNext()) {
                Node removedNode = executionPlanIterator.next();
                executionPlanIterator.remove();
                if (!(removedNode instanceof LocalTaskNode)) continue;
                this.taskMapping.remove(((LocalTaskNode)removedNode).getTask());
            }
        }
    }
}

