/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import org.gradle.api.IllegalDependencyNotation;

public class ParsedModuleStringNotation {
    private String group;
    private String name;
    private String version;
    private String classifier;
    private final String artifactType;

    public ParsedModuleStringNotation(String moduleNotation, String artifactType) {
        this.assignValuesFromModuleNotation(moduleNotation);
        this.artifactType = artifactType;
    }

    private void assignValuesFromModuleNotation(String moduleNotation) {
        int count = 0;
        int idx = 0;
        int cur = -1;
        while (++cur < moduleNotation.length()) {
            if (':' != moduleNotation.charAt(cur)) continue;
            String fragment = moduleNotation.substring(idx, cur);
            this.assignValue(count, fragment);
            idx = cur + 1;
            ++count;
        }
        this.assignValue(count, moduleNotation.substring(idx, cur));
        if (++count < 2 || count > 4) {
            throw new IllegalDependencyNotation("Supplied String module notation '" + moduleNotation + "' is invalid. Example notations: 'org.gradle:gradle-core:2.2', 'org.mockito:mockito-core:1.9.5:javadoc'.");
        }
    }

    private void assignValue(int count, String fragment) {
        switch (count) {
            case 0: {
                this.group = "".equals(fragment) ? null : fragment;
                break;
            }
            case 1: {
                this.name = fragment;
                break;
            }
            case 2: {
                this.version = "".equals(fragment) ? null : fragment;
                break;
            }
            case 3: {
                this.classifier = fragment;
            }
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getArtifactType() {
        return this.artifactType;
    }
}

