/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.scm;

import java.awt.Graphics;
import java.awt.Rectangle;
import org.me4se.scm.ScmComponent;

public class ScmContainer
extends ScmComponent {
    int childCount;
    boolean valid;
    ScmComponent[] children = new ScmComponent[10];
    ScmComponent mouseOwner;
    ScmComponent focus;

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle r = g.getClipBounds();
        for (int i = 0; i < this.childCount; ++i) {
            ScmComponent c = this.children[i];
            if (c.invisible || r != null && (c.x > r.x + r.width || c.y > r.y + r.height || c.x + c.w < r.x || c.y + c.h < r.y)) continue;
            Graphics g2 = g.create(c.x, c.y, c.w, c.h);
            this.children[i].paint(g2);
        }
    }

    public void add(ScmComponent component) {
        this.add(component, this.childCount);
    }

    public void add(ScmComponent component, int index) {
        if (index < 0 || index > this.childCount) {
            throw new IndexOutOfBoundsException();
        }
        if (this.childCount >= this.children.length) {
            ScmComponent[] save = this.children;
            this.children = new ScmComponent[this.childCount + 4];
            System.arraycopy(save, 0, this.children, 0, this.childCount);
        }
        if (index < this.childCount) {
            System.arraycopy(this.children, index, this.children, index + 1, this.childCount - index);
        }
        this.children[index] = component;
        ++this.childCount;
        component.parent = this;
        this.invalidate();
    }

    public ScmComponent getComponentAt(int x, int y) {
        for (int i = this.childCount - 1; i >= 0; --i) {
            ScmComponent c = this.children[i];
            if (!c.contains(x - c.x, y - c.y)) continue;
            return c;
        }
        return null;
    }

    public int getComponentCount() {
        return this.childCount;
    }

    public int indexOf(ScmComponent c) {
        for (int i = 0; i < this.childCount; ++i) {
            if (c != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean keyPressed(String keyCode) {
        return this.focus != null ? this.focus.keyPressed(keyCode) : false;
    }

    public boolean keyReleased(String keyCode) {
        return this.focus != null ? this.focus.keyReleased(keyCode) : false;
    }

    public boolean keyRepeated(String key) {
        return this.focus != null ? this.focus.keyRepeated(key) : false;
    }

    public void remove(int index) {
        this.children[index].parent = null;
        System.arraycopy(this.children, index + 1, this.children, index, --this.childCount - index);
    }

    public void remove(ScmComponent c) {
        int i = this.indexOf(c);
        if (i != -1) {
            this.remove(i);
        }
    }

    public ScmComponent getComponent(int index) {
        if (index < 0 || index >= this.childCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.children[index];
    }

    public void doLayout() {
        for (int i = 0; i < this.childCount; ++i) {
            if (!(this.children[i] instanceof ScmContainer)) continue;
            ScmContainer child = (ScmContainer)this.children[i];
            if (child.fullScreen) {
                child.setBounds(0, 0, this.w, this.h);
            }
            ((ScmComponent)child).doLayout();
        }
    }

    public boolean mouseClicked(int button, int x, int y, int mask, int clicks) {
        ScmComponent c = this.getComponentAt(x, y);
        return c != null ? c.mouseClicked(button, x - c.x, y - c.y, mask, clicks) : false;
    }

    public boolean mouseReleased(int button, int x, int y, int mask) {
        return this.mouseOwner != null ? this.mouseOwner.mouseReleased(button, x - this.mouseOwner.x, y - this.mouseOwner.y, mask) : false;
    }

    public boolean mousePressed(int button, int x, int y, int mask) {
        ScmComponent newOwner = this.getComponentAt(x, y);
        if (newOwner != this.mouseOwner) {
            if (this.mouseOwner != null) {
                this.mouseOwner.mouseExited();
            }
            if (newOwner != null) {
                newOwner.mouseEntered();
            }
            this.mouseOwner = newOwner;
        }
        return this.mouseOwner != null ? this.mouseOwner.mousePressed(button, x - this.mouseOwner.x, y - this.mouseOwner.y, mask) : false;
    }

    public boolean mouseDragged(int x, int y, int mask) {
        return this.mouseOwner != null ? this.mouseOwner.mouseDragged(x - this.mouseOwner.x, y - this.mouseOwner.y, mask) : false;
    }

    public boolean mouseMoved(int x, int y, int mask) {
        return this.mouseOwner != null ? this.mouseOwner.mouseMoved(x - this.mouseOwner.x, y - this.mouseOwner.y, mask) : false;
    }
}

