/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.dita.dost.ant.ExtensibleAntInvoker;
import org.dita.dost.ant.LangParser;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.xml.sax.ContentHandler;

public final class CheckLang
extends Task {
    private File basedir;
    private File outputdir;
    private String inputmap;
    private String message;
    private DITAOTLogger logger;

    public void execute() {
        this.logger = new DITAOTAntLogger(this.getProject());
        this.logger.info(this.message);
        Job job = ExtensibleAntInvoker.getJob((Project)this.getProject());
        if (!this.outputdir.isAbsolute()) {
            this.outputdir = new File(this.basedir, this.outputdir.getPath()).getAbsoluteFile();
        }
        if (!new File(this.inputmap).isAbsolute()) {
            this.inputmap = new File(job.tempDir, this.inputmap).getAbsolutePath();
        }
        LangParser parser = new LangParser();
        try {
            job.getStore().transform(new File(this.inputmap).toURI(), (ContentHandler)parser);
            String langCode = parser.getLangCode();
            if (!StringUtils.isEmptyString((String)langCode)) {
                this.setActiveProjectProperty("htmlhelp.locale", langCode);
            } else {
                for (Job.FileInfo f : job.getFileInfo()) {
                    File topicFile;
                    if (!"dita".equals(f.format) || !(topicFile = new File(job.tempDir, f.file.getPath())).exists()) continue;
                    job.getStore().transform(topicFile.toURI(), (ContentHandler)parser);
                    langCode = parser.getLangCode();
                    if (StringUtils.isEmptyString((String)langCode)) continue;
                    this.setActiveProjectProperty("htmlhelp.locale", langCode);
                    break;
                }
                if (StringUtils.isEmptyString((String)langCode)) {
                    this.setActiveProjectProperty("htmlhelp.locale", "en-us");
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().equals("Search finished")) {
                System.out.println("Lang search finished");
            }
            e.printStackTrace();
        }
    }

    private void setActiveProjectProperty(String propertyName, String propertyValue) {
        Project activeProject = this.getProject();
        if (activeProject != null) {
            activeProject.setProperty(propertyName, propertyValue);
        }
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    @Deprecated
    public void setTempdir(File tempdir) {
    }

    public void setInputmap(String inputmap) {
        this.inputmap = inputmap;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setOutputdir(File outputdir) {
        this.outputdir = outputdir;
    }
}

