/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown.renderer;

import com.elovirta.dita.markdown.DitaRenderer;
import com.elovirta.dita.markdown.ParseException;
import com.elovirta.dita.markdown.SaxWriter;
import com.elovirta.dita.markdown.renderer.AbstractRenderer;
import com.elovirta.dita.markdown.renderer.EndElementHandler;
import com.elovirta.dita.markdown.renderer.NodeRendererContext;
import com.elovirta.dita.markdown.renderer.NodeRenderingHandler;
import com.elovirta.dita.markdown.renderer.StartElementHandler;
import com.elovirta.dita.markdown.renderer.Title;
import com.elovirta.dita.markdown.renderer.Utils;
import com.elovirta.dita.utils.FragmentContentHandler;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.Subscript;
import com.vladsch.flexmark.ext.superscript.Superscript;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.yaml.front.matter.AbstractYamlFrontMatterVisitor;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.util.ast.ContentNode;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.visitor.AstHandler;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MapRenderer
extends AbstractRenderer {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("com.elovirta.dita.messages");
    private static final Attributes MAP_ATTS = new XMLUtils.AttributesBuilder().add("class", Constants.MAP_MAP.toString()).add("http://dita.oasis-open.org/architecture/2005/", "DITAArchVersion", "ditaarch:DITAArchVersion", "CDATA", "2.0").build();
    private static final Attributes TOPICREF_ATTS = Utils.buildAtts(Constants.MAP_TOPICREF);
    private static final Attributes TOPICHEAD_ATTS = Utils.buildAtts(Constants.MAPGROUP_D_TOPICHEAD);
    private static final Attributes TOPICMETA_ATTS = Utils.buildAtts(Constants.MAP_TOPICMETA);
    private static final Attributes NAVTITLE_ATTS = Utils.buildAtts(Constants.TOPIC_NAVTITLE);
    private static final Attributes RELTABLE_ATTS = new XMLUtils.AttributesBuilder().add("class", Constants.MAP_RELTABLE.toString()).add("toc", "no").build();
    private static final Attributes RELHEADER_ATTS = Utils.buildAtts(Constants.MAP_RELHEADER);
    private static final Attributes RELCOLSPEC_ATTS = new XMLUtils.AttributesBuilder().add("class", Constants.MAP_RELCOLSPEC.toString()).add("toc", "no").build();
    private static final Attributes RELROW_ATTS = Utils.buildAtts(Constants.MAP_RELROW);
    private static final Attributes RELCELL_ATTS = Utils.buildAtts(Constants.MAP_RELCELL);
    private static final Attributes KEYDEF_ATTS = Utils.buildAtts(Constants.MAPGROUP_D_KEYDEF);
    private final boolean idFromYaml;
    private static final Map<String, Map.Entry<DitaClass, Attributes>> htmlToDita = Stream.of(new AbstractMap.SimpleImmutableEntry<String, DitaClass>("span", Constants.TOPIC_PH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("code", Constants.PR_D_CODEPH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("s", Constants.HI_D_LINE_THROUGH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("tt", Constants.HI_D_TT), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("b", Constants.HI_D_B), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("strong", Constants.HI_D_B), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("i", Constants.HI_D_I), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("em", Constants.HI_D_I), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("sub", Constants.HI_D_SUB), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("sup", Constants.HI_D_SUP), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("u", Constants.HI_D_U)).flatMap(MapRenderer::createHtmlToDita).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Map<String, Map.Entry<DitaClass, Attributes>> hditaToXdita = Stream.of(new AbstractMap.SimpleImmutableEntry<String, DitaClass>("span", Constants.TOPIC_PH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("code", Constants.TOPIC_PH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("s", Constants.TOPIC_PH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("tt", Constants.HI_D_TT), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("b", Constants.HI_D_B), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("strong", Constants.HI_D_B), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("i", Constants.HI_D_I), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("em", Constants.HI_D_I), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("sub", Constants.HI_D_SUB), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("sup", Constants.HI_D_SUP), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("u", Constants.HI_D_U)).flatMap(MapRenderer::createHtmlToDita).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Class<? extends Node>[] INLINE = List.of(Text.class, TextBase.class, Code.class, Emphasis.class, StrongEmphasis.class, Superscript.class, Subscript.class, Strikethrough.class).toArray(new Class[0]);
    private final boolean onlyImageChild = false;

    public MapRenderer(DataHolder options) {
        super(options);
        this.idFromYaml = (Boolean)DitaRenderer.ID_FROM_YAML.get(options);
    }

    @Override
    public Map<Class<? extends Node>, NodeRenderingHandler<? extends Node>> getNodeRenderingHandlers() {
        ArrayList<NodeRenderingHandler<Object>> res = new ArrayList<NodeRenderingHandler<Object>>();
        res.add(new NodeRenderingHandler<TableBlock>(TableBlock.class, this::renderSimpleTableBlock));
        res.add(new NodeRenderingHandler<TableBody>(TableBody.class, this::renderSimpleTableBody));
        res.add(new NodeRenderingHandler<TableHead>(TableHead.class, this::renderSimpleTableHead));
        res.add(new NodeRenderingHandler<TableRow>(TableRow.class, this::renderSimpleTableRow));
        res.add(new NodeRenderingHandler<TableCell>(TableCell.class, this::renderSimpleTableCell));
        res.add(new NodeRenderingHandler<TableSeparator>(TableSeparator.class, this::renderSimpleTableSeparator));
        res.add(new NodeRenderingHandler<YamlFrontMatterBlock>(YamlFrontMatterBlock.class, this::render));
        res.add(new NodeRenderingHandler<BulletList>(BulletList.class, this::render));
        res.add(new NodeRenderingHandler<Document>(Document.class, this::render));
        res.add(new NodeRenderingHandler<Heading>(Heading.class, this::render));
        res.add(new NodeRenderingHandler<Image>(Image.class, this::render));
        res.add(new NodeRenderingHandler<ImageRef>(ImageRef.class, this::render));
        res.add(new NodeRenderingHandler<Link>(Link.class, this::render));
        res.add(new NodeRenderingHandler<LinkRef>(LinkRef.class, this::render));
        res.add(new NodeRenderingHandler<BulletListItem>(BulletListItem.class, this::render));
        res.add(new NodeRenderingHandler<OrderedListItem>(OrderedListItem.class, this::render));
        res.add(new NodeRenderingHandler<MailLink>(MailLink.class, this::render));
        res.add(new NodeRenderingHandler<OrderedList>(OrderedList.class, this::render));
        res.add(new NodeRenderingHandler<Paragraph>(Paragraph.class, this::render));
        res.add(new NodeRenderingHandler<Reference>(Reference.class, this::render));
        res.add(new NodeRenderingHandler<SoftLineBreak>(SoftLineBreak.class, this::render));
        res.add(new NodeRenderingHandler<Text>(Text.class, this::render));
        HashMap<Class<? extends Node>, NodeRenderingHandler<? extends Node>> map = new HashMap<Class<? extends Node>, NodeRenderingHandler<? extends Node>>(super.getNodeRenderingHandlers());
        map.putAll(res.stream().collect(Collectors.toMap(AstHandler::getNodeType, Function.identity())));
        return map;
    }

    private void render(Document node, NodeRendererContext context, SaxWriter html) {
        Node firstChild;
        boolean isCompound = this.hasMultipleTopLevelHeaders(node);
        if (isCompound) {
            throw new ParseException(String.format("Map file cannot have multiple top level headers", new Object[0]));
        }
        XMLUtils.AttributesBuilder atts = this.mditaCoreProfile || this.mditaExtendedProfile ? new XMLUtils.AttributesBuilder(MAP_ATTS).add("specializations", "") : new XMLUtils.AttributesBuilder(MAP_ATTS).add("specializations", "@props/audience @props/deliveryTarget @props/otherprops @props/platform @props/product");
        String id = null;
        Heading heading = (Heading)node.getChildOfType(new Class[]{Heading.class});
        if (heading != null) {
            StringBuilder buf = new StringBuilder();
            node.getAstExtra(buf);
            Title header = null;
            if (!this.mditaCoreProfile) {
                header = node.getFirstChild() instanceof AnchorLink ? Title.getFromChildren(node.getFirstChild()) : Title.getFromChildren((Node)node);
                header.id.ifPresent(arg_0 -> ((Heading)heading).setAnchorRefId(arg_0));
            }
            id = this.getTopicId(heading, header);
            if (!this.mditaCoreProfile) {
                if (!header.classes.isEmpty()) {
                    atts.add("outputclass", String.join((CharSequence)" ", header.classes));
                }
                for (Map.Entry<String, String> attr : header.attributes.entrySet()) {
                    atts.add(attr.getKey(), attr.getValue());
                }
            }
        }
        if (id != null) {
            atts.add("id", id);
        }
        html.startElement((Node)node, Constants.MAP_MAP, atts.build());
        if (heading == null && (firstChild = node.getFirstChild()) instanceof YamlFrontMatterBlock) {
            html.startElement(firstChild, Constants.MAP_TOPICMETA, TOPICMETA_ATTS);
            this.metadataSerializer.render((YamlFrontMatterBlock)firstChild, context, html);
            html.endElement();
        }
        context.renderChildren((Node)node);
    }

    private void render(BulletList node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(Image node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(this.getInlineAttributes((Node)node, IMAGE_ATTS)).add("href", node.getUrl().toString());
        this.writeImage(node, node.getTitle().toString(), null, atts, context, html);
    }

    private void writeImage(Image node, String title, String alt, XMLUtils.AttributesBuilder atts, NodeRendererContext context, SaxWriter html) {
        html.startElement((Node)node, Constants.TOPIC_IMAGE, atts.build());
        if (node.hasChildren()) {
            html.startElement((Node)node, Constants.TOPIC_ALT, ALT_ATTS);
            if (alt != null) {
                html.characters(alt);
            } else {
                context.renderChildren((Node)node);
            }
            html.endElement();
        }
        html.endElement();
    }

    private void writeImage(ImageRef node, String title, String alt, XMLUtils.AttributesBuilder atts, NodeRendererContext context, SaxWriter html) {
        html.startElement((Node)node, Constants.TOPIC_IMAGE, atts.build());
        if (node.hasChildren()) {
            html.startElement((Node)node, Constants.TOPIC_ALT, ALT_ATTS);
            if (alt != null) {
                html.characters(alt);
            } else {
                context.renderChildren((Node)node);
            }
            html.endElement();
        }
        html.endElement();
    }

    private void render(Heading node, NodeRendererContext context, SaxWriter html) {
        Node firstChild;
        html.startElement((Node)node, Constants.TOPIC_TITLE, TITLE_ATTS);
        context.renderChildren((Node)node);
        html.endElement();
        if (node.getLevel() == 1 && (firstChild = node.getDocument().getFirstChild()) instanceof YamlFrontMatterBlock) {
            html.startElement(firstChild, Constants.MAP_TOPICMETA, TOPICMETA_ATTS);
            this.metadataSerializer.render((YamlFrontMatterBlock)firstChild, context, html);
            html.endElement();
        }
    }

    private String getSectionId(Heading node, Title header) {
        if (header != null) {
            if (node.getAnchorRefId() != null) {
                return node.getAnchorRefId();
            }
            return null;
        }
        if (node.getAnchorRefId() != null) {
            return node.getAnchorRefId();
        }
        return MapRenderer.getId(node.getText().toString());
    }

    private String getTopicId(Heading node, Title header) {
        if (this.idFromYaml && node.getLevel() == 1 && node.getDocument().getChildOfType(new Class[]{YamlFrontMatterBlock.class}) != null) {
            AbstractYamlFrontMatterVisitor v = new AbstractYamlFrontMatterVisitor();
            v.visit((Node)node.getDocument());
            Map metadata = v.getData();
            List ids = (List)metadata.get("id");
            if (ids != null && !ids.isEmpty()) {
                return (String)ids.get(0);
            }
        }
        return this.getSectionId(node, header);
    }

    private void render(YamlFrontMatterBlock node, NodeRendererContext context, SaxWriter html) {
    }

    private static String getId(String contents) {
        return contents.toLowerCase().replaceAll("[^\\w]", "").trim().replaceAll("\\s+", "_");
    }

    private void render(HtmlBlock node, NodeRendererContext context, SaxWriter html) {
        TransformerHandler h;
        String text = node.getChars().toString();
        FragmentContentHandler fragmentFilter = new FragmentContentHandler();
        fragmentFilter.setContentHandler(html);
        try {
            h = ((SAXTransformerFactory)this.transformerFactorySupplier.get()).newTransformerHandler((Templates)this.templatesSupplier.get());
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Transformer transformer = h.getTransformer();
        transformer.setParameter("formats", String.join((CharSequence)",", this.formats));
        transformer.setParameter("raw-dita", this.rawDita);
        h.setResult(new SAXResult(fragmentFilter));
        HtmlParser parser = new HtmlParser();
        parser.setContentHandler((ContentHandler)h);
        try {
            html.setLocation((Node)node);
            parser.parse(new InputSource(new StringReader(text)));
        }
        catch (IOException | SAXException e) {
            throw new ParseException(String.format(MESSAGES.getString("error.html_parse_fail"), e.getMessage()), e);
        }
        html.setDocumentLocator();
    }

    private static Stream<Map.Entry<String, Map.Entry<DitaClass, Attributes>>> createHtmlToDita(Map.Entry<String, DitaClass> e) {
        AbstractMap.SimpleImmutableEntry<DitaClass, Attributes> value = new AbstractMap.SimpleImmutableEntry<DitaClass, Attributes>(e.getValue(), Utils.buildAtts(e.getValue()));
        return Stream.of(new AbstractMap.SimpleImmutableEntry<CallSite, AbstractMap.SimpleImmutableEntry<DitaClass, Attributes>>((CallSite)((Object)("<" + e.getKey() + ">")), value), new AbstractMap.SimpleImmutableEntry<CallSite, AbstractMap.SimpleImmutableEntry<DitaClass, Attributes>>((CallSite)((Object)("</" + e.getKey() + ">")), value));
    }

    private void render(HtmlInline node, NodeRendererContext context, SaxWriter html) {
        block20: {
            TransformerHandler h;
            String text;
            Map.Entry<DitaClass, Attributes> entry = (this.mditaExtendedProfile ? hditaToXdita : htmlToDita).get(text = node.getChars().toString());
            if (entry != null) {
                DitaClass cls = entry.getKey();
                html.setLocation((Node)node);
                if (text.startsWith("</")) {
                    html.endElement(cls);
                } else {
                    html.startElement((Node)node, cls, entry.getValue());
                }
                return;
            }
            try {
                h = ((SAXTransformerFactory)this.transformerFactorySupplier.get()).newTransformerHandler((Templates)this.templatesSupplier.get());
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            h.getTransformer().setParameter("formats", String.join((CharSequence)",", this.formats));
            HtmlParser parser = new HtmlParser(XmlViolationPolicy.ALLOW);
            parser.setContentHandler((ContentHandler)h);
            html.setLocation((Node)node);
            if (text.startsWith("</")) {
                h.setResult(new SAXResult(new EndElementHandler(html)));
                String data = text.replaceAll("/", "") + text;
                try (StringReader in = new StringReader(data);){
                    parser.parse(new InputSource(in));
                    break block20;
                }
                catch (IOException | SAXException e) {
                    throw new ParseException(String.format(MESSAGES.getString("error.html_parse_fail"), e.getMessage()), e);
                }
            }
            h.setResult(new SAXResult(new StartElementHandler(html)));
            try (StringReader in = new StringReader(text);){
                parser.parse(new InputSource(in));
            }
            catch (IOException | SAXException e) {
                throw new ParseException(String.format(MESSAGES.getString("error.html_parse_fail"), e.getMessage()), e);
            }
        }
        html.setDocumentLocator();
    }

    private void render(ListItem node, NodeRendererContext context, SaxWriter html) {
        Node next;
        Node child;
        XMLUtils.AttributesBuilder atts;
        DitaClass name;
        List<Node> navtitle;
        block12: {
            Paragraph paragraph;
            block11: {
                String text;
                LinkRef linkRef;
                block14: {
                    Reference refNode;
                    block13: {
                        paragraph = (Paragraph)node.getChildOfType(new Class[]{Paragraph.class});
                        Link link = paragraph != null ? (Link)paragraph.getChildOfType(new Class[]{Link.class}) : null;
                        linkRef = paragraph != null ? (LinkRef)paragraph.getChildOfType(new Class[]{LinkRef.class}) : null;
                        navtitle = null;
                        if (link == null && linkRef == null) break block11;
                        name = Constants.MAP_TOPICREF;
                        atts = new XMLUtils.AttributesBuilder(TOPICREF_ATTS);
                        if (link != null) {
                            atts.addAll(this.getLinkAttributes(link.getUrl().toString(), TOPICREF_ATTS).build());
                            text = link.getText().toString();
                            if (!text.isEmpty()) {
                                navtitle = this.childList((Node)link);
                            }
                        }
                        if (linkRef == null) break block12;
                        text = linkRef.getText().toString();
                        String key = linkRef.getReference() != null ? linkRef.getReference().toString() : text;
                        refNode = linkRef.getReferenceNode(linkRef.getDocument());
                        if (refNode != null) break block13;
                        atts.add("keyref", key);
                        if (!text.isBlank()) {
                            navtitle = this.childList((Node)linkRef);
                        }
                        break block12;
                    }
                    atts.addAll(this.getLinkAttributes(refNode.getUrl().toString(), TOPICREF_ATTS).build());
                    atts.add("keyref", refNode.getReference().toString());
                    if (refNode.getTitle().toString().isEmpty()) break block14;
                    navtitle = this.childList((Node)refNode);
                    break block12;
                }
                if (text == null || text.isBlank()) break block12;
                navtitle = this.childList((Node)linkRef);
                break block12;
            }
            if (this.mditaCoreProfile || this.mditaExtendedProfile) {
                name = Constants.MAP_TOPICREF;
                atts = new XMLUtils.AttributesBuilder(TOPICREF_ATTS);
            } else {
                name = Constants.MAPGROUP_D_TOPICHEAD;
                atts = new XMLUtils.AttributesBuilder(TOPICHEAD_ATTS);
            }
            navtitle = new ArrayList<Node>();
            child = paragraph.getFirstChild();
            while (child != null) {
                next = child.getNext();
                if (child.isOrDescendantOfType((Class[])INLINE)) {
                    navtitle.add(child);
                } else if (child instanceof BulletList || child instanceof OrderedList) break;
                child = next;
            }
        }
        if (node instanceof OrderedListItem && !this.mditaCoreProfile && !this.mditaExtendedProfile) {
            atts.add("collection-type", "sequence");
        }
        html.startElement((Node)node, name, this.getInlineAttributes((Node)node, atts.build()));
        this.renderNavtitle((Node)node, context, html, navtitle);
        child = node.getFirstChild();
        while (child != null) {
            next = child.getNext();
            if (child instanceof BulletList || child instanceof OrderedList) {
                context.renderChildren(child);
            }
            child = next;
        }
        html.endElement();
    }

    private void renderNavtitle(Node node, NodeRendererContext context, SaxWriter html, List<Node> navtitle) {
        if (navtitle != null && !navtitle.isEmpty()) {
            html.startElement(node, Constants.MAP_TOPICMETA, TOPICMETA_ATTS);
            html.startElement(node, Constants.TOPIC_NAVTITLE, NAVTITLE_ATTS);
            for (Node child : navtitle) {
                context.renderChild(child);
            }
            html.endElement();
            html.endElement();
        }
    }

    private void render(MailLink node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = this.getLinkAttributes("mailto:" + node.getText());
        atts.add("format", "email");
        html.startElement((Node)node, Constants.TOPIC_XREF, this.getInlineAttributes((Node)node, atts.build()));
        context.renderChildren((Node)node);
        html.endElement();
    }

    private void render(OrderedList node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private boolean isAttributesParagraph(Node node) {
        if (node == null) {
            return false;
        }
        Node firstChild = node.getFirstChild();
        return firstChild instanceof AttributesNode && firstChild.getNext() == null;
    }

    private void render(Reference node, NodeRendererContext context, SaxWriter html) {
        Attributes atts = this.getLinkAttributes(node.getUrl().toString(), KEYDEF_ATTS).add("keys", node.getReference().toString()).build();
        html.startElement((Node)node, Constants.MAPGROUP_D_KEYDEF, atts);
        html.endElement();
    }

    private void render(ImageRef node, NodeRendererContext context, SaxWriter html) {
        String text = node.getText().toString();
        String key = node.getReference() != null ? node.getReference().toString() : text;
        Reference refNode = node.getReferenceNode(node.getDocument());
        if (refNode == null) {
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(IMAGE_ATTS).add("keyref", key);
            html.startElement((Node)node, Constants.TOPIC_IMAGE, this.getInlineAttributes((Node)node, atts.build()));
            html.endElement();
        } else {
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(this.getInlineAttributes((Node)node, IMAGE_ATTS)).add("href", refNode.getUrl().toString());
            if (key != null) {
                atts.add("keyref", key);
            }
            this.writeImage(node, refNode.getTitle().toString(), text, atts, context, html);
        }
    }

    private void render(RefNode node, NodeRendererContext context, SaxWriter html) {
        String text = node.getText().toString();
        String key = node.getReference() != null ? node.getReference().toString() : text;
        Reference refNode = node.getReferenceNode(node.getDocument());
        if (refNode == null) {
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(TOPICREF_ATTS).add("keyref", key);
            html.startElement((Node)node, Constants.MAP_TOPICREF, atts.build());
            if (!node.getText().toString().isEmpty()) {
                this.renderNavtitle((Node)node, context, html, this.childList((Node)node));
            }
            html.endElement();
        } else {
            XMLUtils.AttributesBuilder atts = this.getLinkAttributes(refNode.getUrl().toString());
            html.startElement((Node)node, Constants.MAP_TOPICREF, atts.build());
            if (!refNode.getTitle().toString().isEmpty()) {
                this.renderNavtitle((Node)node, context, html, this.childList((Node)refNode));
            } else {
                this.renderNavtitle((Node)node, context, html, this.childList((Node)node));
            }
            html.endElement();
        }
    }

    private void render(Link node, NodeRendererContext context, SaxWriter html) {
        String text = node.getText().toString();
        XMLUtils.AttributesBuilder atts = this.getLinkAttributes(node.getUrl().toString());
        html.startElement((Node)node, Constants.MAP_TOPICREF, this.getInlineAttributes((Node)node, atts.build()));
        this.renderNavtitle((Node)node, context, html, this.childList((Node)node));
        html.endElement();
    }

    private void renderSimpleTableBlock(TableBlock node, NodeRendererContext context, SaxWriter html) {
        Attributes tableAtts;
        if (!this.mditaExtendedProfile && this.isAttributesParagraph(node.getNext())) {
            Title header = Title.getFromChildren(node.getNext());
            XMLUtils.AttributesBuilder builder = new XMLUtils.AttributesBuilder(RELTABLE_ATTS);
            tableAtts = this.readAttributes(header, builder).build();
        } else {
            tableAtts = RELTABLE_ATTS;
        }
        html.startElement((Node)node, Constants.MAP_RELTABLE, tableAtts);
        context.renderChildren((Node)node);
        html.endElement();
    }

    private void renderSimpleTableHead(TableHead node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void renderSimpleTableBody(TableBody node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void renderSimpleTableSeparator(TableSeparator node, NodeRendererContext context, SaxWriter html) {
    }

    private void renderSimpleTableRow(TableRow node, NodeRendererContext context, SaxWriter html) {
        if (node.getParent() instanceof TableHead) {
            this.printTag((Node)node, context, html, Constants.MAP_RELHEADER, RELHEADER_ATTS);
        } else {
            this.printTag((Node)node, context, html, Constants.MAP_RELROW, RELROW_ATTS);
        }
    }

    private void renderSimpleTableCell(TableCell node, NodeRendererContext context, SaxWriter html) {
        boolean isHeader = node.getParent().getParent().isOrDescendantOfType(new Class[]{TableHead.class});
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(isHeader ? RELCOLSPEC_ATTS : RELCELL_ATTS);
        html.startElement((Node)node, isHeader ? Constants.MAP_RELCOLSPEC : Constants.MAP_RELCELL, atts.build());
        context.renderChildren((Node)node);
        html.endElement();
    }

    private void render(Text node, NodeRendererContext context, SaxWriter html) {
        if (node.getParent() instanceof Code) {
            html.characters(node.getChars().toString());
        } else {
            html.characters(node.getChars().unescapeNoEntities());
        }
    }

    private void render(ContentNode node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(SoftLineBreak node, NodeRendererContext context, SaxWriter html) {
        html.characters('\n');
    }

    private void render(Node node, NodeRendererContext context, SaxWriter html) {
        throw new RuntimeException("No renderer configured for " + node.getNodeName() + " = " + node.getClass().getCanonicalName());
    }

    @Override
    protected XMLUtils.AttributesBuilder getLinkAttributes(String href) {
        return this.getLinkAttributes(href, TOPICREF_ATTS);
    }
}

