/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dita.index.IndexEntry;
import org.w3c.dom.Node;

public class IndexEntryImpl
implements IndexEntry {
    private final String value;
    private final String formattedString;
    private final List<Node> contents;
    private String sortString;
    private final Map<String, IndexEntry> childs = new HashMap<String, IndexEntry>();
    private final Map<String, IndexEntry> seeChilds = new HashMap<String, IndexEntry>();
    private final Map<String, IndexEntry> seeAlsoChilds = new HashMap<String, IndexEntry>();
    private boolean startRange = false;
    private boolean endsRange = false;
    private boolean suppressesThePageNumber = false;
    private boolean restoresPageNumber = false;
    private final Set<String> refIDs = new HashSet<String>();

    public IndexEntryImpl(String value, String sortString, String formattedString, List<Node> contents) {
        this.value = value;
        this.sortString = sortString;
        this.formattedString = formattedString;
        this.contents = contents;
    }

    @Override
    public Set<String> getRefIDs() {
        return this.refIDs;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getFormattedString() {
        return this.formattedString;
    }

    @Override
    public List<Node> getContents() {
        return this.contents;
    }

    @Override
    public String getSortString() {
        return this.sortString;
    }

    @Override
    public List<IndexEntry> getChildIndexEntries() {
        return this.childs.isEmpty() ? Collections.emptyList() : new ArrayList<IndexEntry>(this.childs.values());
    }

    @Override
    public boolean isStartingRange() {
        return this.startRange;
    }

    @Override
    public boolean isEndingRange() {
        return this.endsRange;
    }

    @Override
    public boolean isSuppressesThePageNumber() {
        return this.suppressesThePageNumber;
    }

    @Override
    public boolean isRestoresPageNumber() {
        return this.restoresPageNumber;
    }

    @Override
    public void addRefID(String id) {
        this.refIDs.add(id);
    }

    @Override
    public void addSeeChild(IndexEntry entry) {
        String entryValue = entry.getValue();
        if (!this.seeChilds.containsKey(entryValue)) {
            this.seeChilds.put(entryValue, entry);
            return;
        }
        IndexEntry existingEntry = this.seeChilds.get(entryValue);
        List<IndexEntry> childIndexEntries = entry.getChildIndexEntries();
        for (IndexEntry childIndexEntry : childIndexEntries) {
            existingEntry.addChild(childIndexEntry);
        }
        if (entry.isRestoresPageNumber()) {
            existingEntry.setRestoresPageNumber(true);
        }
        if (!entry.isSuppressesThePageNumber()) {
            existingEntry.setSuppressesThePageNumber(false);
        }
        if (entry.isStartingRange()) {
            existingEntry.setStartRange(true);
        }
        if (entry.getSortString() != null) {
            existingEntry.setSortString(entry.getSortString());
        }
    }

    @Override
    public void addSeeAlsoChild(IndexEntry entry) {
        String entryValue = entry.getValue();
        if (!this.seeAlsoChilds.containsKey(entryValue)) {
            this.seeAlsoChilds.put(entryValue, entry);
            return;
        }
        IndexEntry existingEntry = this.seeAlsoChilds.get(entryValue);
        List<IndexEntry> childIndexEntries = entry.getChildIndexEntries();
        for (IndexEntry childIndexEntry : childIndexEntries) {
            existingEntry.addChild(childIndexEntry);
        }
        if (entry.isRestoresPageNumber()) {
            existingEntry.setRestoresPageNumber(true);
        }
        if (!entry.isSuppressesThePageNumber()) {
            existingEntry.setSuppressesThePageNumber(false);
        }
        if (entry.isStartingRange()) {
            existingEntry.setStartRange(true);
        }
        if (entry.getSortString() != null) {
            existingEntry.setSortString(entry.getSortString());
        }
    }

    @Override
    public void addChild(IndexEntry entry) {
        String entryValue = entry.getValue();
        if (!this.childs.containsKey(entryValue)) {
            this.childs.put(entryValue, entry);
            return;
        }
        IndexEntry existingEntry = this.childs.get(entryValue);
        List<IndexEntry> childIndexEntries = entry.getChildIndexEntries();
        for (IndexEntry childIndexEntry : childIndexEntries) {
            existingEntry.addChild(childIndexEntry);
        }
        if (entry.isRestoresPageNumber()) {
            existingEntry.setRestoresPageNumber(true);
        }
        if (!entry.isSuppressesThePageNumber()) {
            existingEntry.setSuppressesThePageNumber(false);
        }
        if (entry.isStartingRange()) {
            existingEntry.setStartRange(true);
        }
        if (entry.getSortString() != null) {
            existingEntry.setSortString(entry.getSortString());
        }
    }

    @Override
    public void setSortString(String sortString) {
        this.sortString = sortString;
    }

    @Override
    public void setStartRange(boolean startRange) {
        if (startRange && this.endsRange) {
            this.endsRange = false;
        }
        this.startRange = startRange;
    }

    @Override
    public void setEndsRange(boolean endsRange) {
        if (endsRange && this.startRange) {
            this.startRange = false;
        }
        this.endsRange = endsRange;
    }

    @Override
    public void setSuppressesThePageNumber(boolean suppressesThePageNumber) {
        if (suppressesThePageNumber && this.restoresPageNumber) {
            this.restoresPageNumber = false;
        }
        this.suppressesThePageNumber = suppressesThePageNumber;
    }

    @Override
    public void setRestoresPageNumber(boolean restoresPageNumber) {
        if (restoresPageNumber && this.suppressesThePageNumber) {
            this.suppressesThePageNumber = false;
        }
        this.restoresPageNumber = restoresPageNumber;
    }

    @Override
    public List<IndexEntry> getSeeChildIndexEntries() {
        return this.seeChilds.isEmpty() ? null : new ArrayList<IndexEntry>(this.seeChilds.values());
    }

    @Override
    public List<IndexEntry> getSeeAlsoChildIndexEntries() {
        return this.seeAlsoChilds.isEmpty() ? null : new ArrayList<IndexEntry>(this.seeAlsoChilds.values());
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getValue());
        if (this.isSuppressesThePageNumber()) {
            result.append("<$nopage>");
        }
        if (this.isRestoresPageNumber()) {
            result.append("<$singlepage>");
        }
        if (this.isStartingRange()) {
            result.append("<$startrange>");
        }
        if (this.isEndingRange()) {
            result.append("<$endrange>");
        }
        if (this.getSortString() != null && this.getSortString().length() > 0) {
            result.append("[").append(this.getSortString()).append("]");
        }
        return result.toString();
    }
}

