/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.cc.base.services.ConfigurationCacheEnvironmentChangeTracker;
import org.gradle.internal.cc.impl.IgnoredConfigurationInputs;
import org.gradle.internal.cc.impl.InstrumentedInputAccessListenerKt;
import org.gradle.internal.cc.impl.UndeclaredBuildInputListener;
import org.gradle.internal.cc.impl.Workarounds;
import org.gradle.internal.cc.impl.initialization.ConfigurationCacheProblemsListener;
import org.gradle.internal.configuration.inputs.InstrumentedInputsListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010 \u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gradle/internal/cc/impl/InstrumentedInputAccessListener;", "Lorg/gradle/internal/configuration/inputs/InstrumentedInputsListener;", "listenerManager", "Lorg/gradle/internal/event/ListenerManager;", "configurationCacheProblemsListener", "Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheProblemsListener;", "environmentChangeTracker", "Lorg/gradle/internal/cc/base/services/ConfigurationCacheEnvironmentChangeTracker;", "ignoredConfigurationInputs", "Lorg/gradle/internal/cc/impl/IgnoredConfigurationInputs;", "(Lorg/gradle/internal/event/ListenerManager;Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheProblemsListener;Lorg/gradle/internal/cc/base/services/ConfigurationCacheEnvironmentChangeTracker;Lorg/gradle/internal/cc/impl/IgnoredConfigurationInputs;)V", "externalProcessListener", "undeclaredInputBroadcast", "Lorg/gradle/internal/cc/impl/UndeclaredBuildInputListener;", "directoryContentObserved", "", "directory", "Ljava/io/File;", "consumer", "", "envVariableQueried", "key", "value", "externalProcessStarted", "command", "fileObserved", "file", "fileOpened", "fileSystemEntryObserved", "systemPropertiesCleared", "systemPropertyChanged", "", "systemPropertyQueried", "systemPropertyRemoved", "configuration-cache"})
public final class InstrumentedInputAccessListener
implements InstrumentedInputsListener {
    @NotNull
    private final ConfigurationCacheEnvironmentChangeTracker environmentChangeTracker;
    @NotNull
    private final IgnoredConfigurationInputs ignoredConfigurationInputs;
    @NotNull
    private final UndeclaredBuildInputListener undeclaredInputBroadcast;
    @NotNull
    private final ConfigurationCacheProblemsListener externalProcessListener;

    public InstrumentedInputAccessListener(@NotNull ListenerManager listenerManager, @NotNull ConfigurationCacheProblemsListener configurationCacheProblemsListener, @NotNull ConfigurationCacheEnvironmentChangeTracker environmentChangeTracker, @NotNull IgnoredConfigurationInputs ignoredConfigurationInputs) {
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        Intrinsics.checkNotNullParameter((Object)configurationCacheProblemsListener, (String)"configurationCacheProblemsListener");
        Intrinsics.checkNotNullParameter((Object)environmentChangeTracker, (String)"environmentChangeTracker");
        Intrinsics.checkNotNullParameter((Object)ignoredConfigurationInputs, (String)"ignoredConfigurationInputs");
        this.environmentChangeTracker = environmentChangeTracker;
        this.ignoredConfigurationInputs = ignoredConfigurationInputs;
        Object object = listenerManager.getBroadcaster(UndeclaredBuildInputListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"listenerManager.getBroad\u2026nputListener::class.java)");
        this.undeclaredInputBroadcast = (UndeclaredBuildInputListener)object;
        this.externalProcessListener = configurationCacheProblemsListener;
    }

    public void systemPropertyQueried(@NotNull String key, @Nullable Object value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (InstrumentedInputAccessListenerKt.access$getAllowedProperties$p().contains(key) || Workarounds.INSTANCE.canReadSystemProperty(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.systemPropertyRead(key, value, consumer);
    }

    public void systemPropertyChanged(@NotNull Object key, @Nullable Object value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.environmentChangeTracker.systemPropertyChanged(key, value, consumer);
    }

    public void systemPropertyRemoved(@NotNull Object key, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.environmentChangeTracker.systemPropertyRemoved(key);
    }

    public void systemPropertiesCleared(@NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.environmentChangeTracker.systemPropertiesCleared();
    }

    public void envVariableQueried(@NotNull String key, @Nullable String value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadEnvironmentVariable(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.envVariableRead(key, value, consumer);
    }

    public void externalProcessStarted(@NotNull String command, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canStartExternalProcesses(consumer)) {
            return;
        }
        this.externalProcessListener.onExternalProcessStarted(command, consumer);
    }

    public void fileOpened(@NotNull File file, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadFiles(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.fileOpened(file, consumer);
    }

    public void fileObserved(@NotNull File file, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.undeclaredInputBroadcast.fileObserved(file, consumer);
    }

    public void fileSystemEntryObserved(@NotNull File file, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadFiles(consumer)) {
            return;
        }
        if (this.ignoredConfigurationInputs.isFileSystemCheckIgnoredFor(file)) {
            return;
        }
        this.undeclaredInputBroadcast.fileSystemEntryObserved(file, consumer);
    }

    public void directoryContentObserved(@NotNull File directory, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadFiles(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.directoryChildrenObserved(directory, consumer);
    }
}

