/******************************************************************************
 *{@C
 *      Copyright:      2005-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       glew.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the OpenGL library
 *                      contained in file glew.h.
 *
 *****************************************************************************/

%include tcl3dDefines.i

// Redefine the function with a return value, so that the SWIG generated
// wrapper function returns a Tcl string.
// Maybe this could be made more elegant with typemaps ??
const char *glGetString (GLenum name);

// Redefine 3rd parameter as GLint instead of GLuint (as in the OpenGL header
// file). Passing 0xFFFFFFFF as mask on Mac OSX generates Overflow errors.
#if defined (Darwin) || defined (WIN32) || (defined (Linux) && !defined (Linux64))
    %ignore glStencilFunc (GLenum func, GLint ref, GLuint mask);
    void glStencilFunc (GLenum func, GLint ref, GLint mask);
#endif

// The following query functions are redefined. Instead of a "GLchar *" we
// use a "GLubyte *", so SWIG does not use it's standard mapping.
// There are Tcl utility procedures for easier use of these functions.
GLvoid glGetShaderInfoLog (GLuint shader, GLsizei maxLength,
                           GLsizei *length, GLubyte *infoLog);
GLvoid glGetProgramInfoLog (GLuint program, GLsizei maxLength,
                            GLsizei *length, GLubyte *infoLog);
GLvoid glGetShaderSource (GLuint shader, GLsizei bufSize,
                          GLsizei *length, GLubyte *source);
GLvoid glGetInfoLogARB (GLhandleARB object, GLsizei maxLength,
                        GLsizei *length, GLubyte *infoLog);
