/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.api.data;

import com.impossibl.postgres.utils.guava.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ACLItem {
    private String user;
    private String privileges;
    private String grantor;
    private static final Pattern ACL_PATTERN = Pattern.compile("(.*)=(\\w*)/(.*)");

    public ACLItem(String user, String privileges, String grantor) {
        this.user = user;
        this.privileges = privileges;
        this.grantor = grantor;
    }

    private ACLItem() {
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(String privileges) {
        this.privileges = privileges;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public void setGrantor(String grantor) {
        this.grantor = grantor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.user != null && !this.user.equals("PUBLIC")) {
            sb.append(this.user);
        }
        sb.append('=');
        if (this.privileges != null) {
            sb.append(this.privileges);
        }
        sb.append('/');
        if (this.grantor != null) {
            sb.append(this.grantor);
        }
        return sb.toString();
    }

    public static ACLItem parse(String aclItemStr) {
        ACLItem aclItem = null;
        Matcher aclMatcher = ACL_PATTERN.matcher(aclItemStr);
        if (aclMatcher.matches()) {
            aclItem = new ACLItem();
            aclItem.user = aclMatcher.group(1);
            if (Strings.isNullOrEmpty(aclItem.user)) {
                aclItem.user = "PUBLIC";
            }
            aclItem.privileges = aclMatcher.group(2);
            aclItem.grantor = aclMatcher.group(3);
        }
        return aclItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.grantor == null ? 0 : this.grantor.hashCode());
        result = 31 * result + (this.privileges == null ? 0 : this.privileges.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ACLItem other = (ACLItem)obj;
        if (this.grantor == null ? other.grantor != null : !this.grantor.equals(other.grantor)) {
            return false;
        }
        if (this.privileges == null ? other.privileges != null : !this.privileges.equals(other.privileges)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

