/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime.instants;

import com.impossibl.postgres.datetime.instants.FutureInfiniteInstant;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.PastInfiniteInstant;
import com.impossibl.postgres.datetime.instants.PreciseInstant;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class Instants {
    public static Instant timeFromPieces(Map<String, Object> pieces, TimeZone zone) {
        Integer nanoseconds;
        Integer seconds;
        Integer minutes;
        Integer hours = (Integer)pieces.get("HOURS");
        if (hours == null) {
            hours = 0;
        }
        if ((minutes = (Integer)pieces.get("MINUTES")) == null) {
            minutes = 0;
        }
        if ((seconds = (Integer)pieces.get("SECONDS")) == null) {
            seconds = 0;
        }
        if ((nanoseconds = (Integer)pieces.get("NANOSECONDS")) == null) {
            nanoseconds = 0;
        }
        TimeZone incZone = null;
        String zoneId = (String)pieces.get("ZONE");
        if (zoneId != null) {
            incZone = TimeZone.getTimeZone(zoneId);
        }
        long micros = 0L;
        micros += TimeUnit.HOURS.toMicros(hours.intValue());
        micros += TimeUnit.MINUTES.toMicros(minutes.intValue());
        micros += TimeUnit.SECONDS.toMicros(seconds.intValue());
        micros += TimeUnit.NANOSECONDS.toMicros(nanoseconds.intValue());
        if (incZone != null) {
            micros -= TimeUnit.MILLISECONDS.toMicros(incZone.getOffset(TimeUnit.MICROSECONDS.toMillis(micros)));
            micros += TimeUnit.MILLISECONDS.toMicros(zone.getOffset(TimeUnit.MICROSECONDS.toMillis(micros)));
        }
        return new PreciseInstant(Instant.Type.Time, micros, zone);
    }

    public static Instant dateFromPieces(Map<String, Object> pieces, TimeZone defaultZone) {
        Integer day;
        Integer month;
        Integer year = (Integer)pieces.get("YEAR");
        if (year == null) {
            year = 1970;
        }
        if ((month = (Integer)pieces.get("MONTH")) == null) {
            month = 1;
        }
        if ((day = (Integer)pieces.get("DAY")) == null) {
            day = 1;
        }
        TimeZone zone = defaultZone;
        String zoneId = (String)pieces.get("ZONE");
        if (zoneId != null) {
            zone = TimeZone.getTimeZone(zoneId);
        }
        Calendar cal = Calendar.getInstance(zone);
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long millis = cal.getTimeInMillis();
        long micros = TimeUnit.MILLISECONDS.toMicros(millis);
        return new PreciseInstant(Instant.Type.Date, micros += TimeUnit.MILLISECONDS.toMicros(zone.getOffset(millis)), zone);
    }

    public static Instant timestampFromPieces(Map<String, Object> pieces, TimeZone zone) {
        Object infinity;
        String zoneId;
        Integer nanoseconds;
        Integer seconds;
        Integer minutes;
        Integer hours;
        Integer day;
        Integer month;
        Integer year = (Integer)pieces.get("YEAR");
        if (year == null) {
            year = 1970;
        }
        if ((month = (Integer)pieces.get("MONTH")) == null) {
            month = 1;
        }
        if ((day = (Integer)pieces.get("DAY")) == null) {
            day = 1;
        }
        if ((hours = (Integer)pieces.get("HOURS")) == null) {
            hours = 0;
        }
        if ((minutes = (Integer)pieces.get("MINUTES")) == null) {
            minutes = 0;
        }
        if ((seconds = (Integer)pieces.get("SECONDS")) == null) {
            seconds = 0;
        }
        if ((nanoseconds = (Integer)pieces.get("NANOSECONDS")) == null) {
            nanoseconds = 0;
        }
        if ((zoneId = (String)pieces.get("ZONE")) != null) {
            zone = TimeZone.getTimeZone(zoneId);
        }
        if ((infinity = pieces.get("INFINITY")) != null) {
            return (Instant)infinity;
        }
        Calendar cal = Calendar.getInstance(zone);
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, 0);
        long millis = cal.getTimeInMillis();
        long micros = TimeUnit.MILLISECONDS.toMicros(millis);
        micros += TimeUnit.NANOSECONDS.toMicros(nanoseconds.intValue());
        return new PreciseInstant(Instant.Type.Timestamp, micros += TimeUnit.MILLISECONDS.toMicros(zone.getOffset(millis)), zone);
    }

    public static Instant fromTimestamp(Timestamp ts, TimeZone zone) {
        long micros;
        long millis = ts.getTime();
        int extra = ts.getNanos() % 1000000 / 1000;
        if (TimeUnit.MILLISECONDS.toNanos(millis) == Long.MIN_VALUE) {
            ++millis;
            extra -= 1000;
        }
        if ((micros = TimeUnit.MILLISECONDS.toMicros(millis) + (long)extra) == Long.MAX_VALUE) {
            return FutureInfiniteInstant.INSTANCE;
        }
        if (micros == Long.MIN_VALUE) {
            return PastInfiniteInstant.INSTANCE;
        }
        return new PreciseInstant(Instant.Type.Timestamp, micros += TimeUnit.MILLISECONDS.toMicros(zone.getOffset(millis)), zone);
    }

    public static Instant fromDate(Date d, TimeZone zone) {
        long millis = d.getTime();
        if (millis == Long.MAX_VALUE) {
            return FutureInfiniteInstant.INSTANCE;
        }
        if (millis == Long.MIN_VALUE) {
            return PastInfiniteInstant.INSTANCE;
        }
        millis += (long)zone.getOffset(millis);
        long micros = TimeUnit.MILLISECONDS.toMicros(millis);
        return new PreciseInstant(Instant.Type.Date, micros, zone);
    }

    public static Instant fromTime(Time t, TimeZone zone) {
        long millis = t.getTime();
        long micros = TimeUnit.MILLISECONDS.toMicros(millis);
        return new PreciseInstant(Instant.Type.Time, micros += TimeUnit.MILLISECONDS.toMicros(zone.getOffset(millis)), zone);
    }
}

