/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SQLTextTree {

    public static class WhitespacePiece
    extends PieceNode {
        WhitespacePiece(String val, int startPos) {
            super(val, startPos);
        }
    }

    public static class CommentPiece
    extends PieceNode {
        CommentPiece(String val, int startPos) {
            super(val, startPos);
        }
    }

    public static class ReplacementPiece
    extends PieceNode {
        ReplacementPiece(String val, int startPos) {
            super(val, startPos);
        }
    }

    public static class NumericLiteralPiece
    extends LiteralPiece {
        NumericLiteralPiece(String val, int startPos) {
            super(val, startPos);
        }
    }

    public static class StringLiteralPiece
    extends LiteralPiece {
        String delimeter;

        StringLiteralPiece(String val, int startPos) {
            super(val, startPos);
            this.delimeter = "'";
        }

        StringLiteralPiece(String val, String delimeter, int startPos) {
            super(val, startPos);
            this.delimeter = delimeter;
        }

        @Override
        void build(StringBuilder builder) {
            builder.append(this.delimeter);
            super.build(builder);
            builder.append(this.delimeter);
        }
    }

    public static class LiteralPiece
    extends PieceNode {
        public LiteralPiece(String val, int startPos) {
            super(val, startPos);
        }
    }

    public static class QuotedIdentifierPiece
    extends IdentifierPiece {
        QuotedIdentifierPiece(String val, int startPos) {
            super(val, startPos);
        }

        @Override
        void build(StringBuilder builder) {
            builder.append('\"');
            super.build(builder);
            builder.append('\"');
        }
    }

    public static class UnquotedIdentifierPiece
    extends IdentifierPiece {
        UnquotedIdentifierPiece(String val, int startPos) {
            super(val, startPos);
        }
    }

    public static class IdentifierPiece
    extends PieceNode {
        public IdentifierPiece(String val, int startPos) {
            super(val, startPos);
        }
    }

    public static class ParameterPiece
    extends PieceNode {
        int idx;

        ParameterPiece(int idx, int pos) {
            super("$" + idx, pos);
            this.idx = idx;
        }

        @Override
        public Node copy() {
            return new ParameterPiece(this.idx, this.getStartPos());
        }

        public int getIdx() {
            return this.idx;
        }

        public void setIdx(int idx) {
            this.idx = idx;
            this.setText("$" + idx);
        }
    }

    public static class GrammarPiece
    extends PieceNode {
        GrammarPiece(String val, int startPos) {
            super(val, startPos);
        }
    }

    public static class PieceNode
    extends Node {
        private String text;

        public PieceNode(String val, int startPos) {
            super(startPos, startPos + val.length());
            this.text = val;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        void coalesce(PieceNode otherPiece) {
            this.setText(this.getText() + otherPiece.getText());
            this.setEndPos(this.getStartPos() + this.getText().length());
        }

        @Override
        void build(StringBuilder builder) {
            builder.append(this.text);
        }

        @Override
        public String toString() {
            return this.text;
        }
    }

    public static class ParenGroupNode
    extends CompositeNode {
        public ParenGroupNode(int startPos) {
            super(startPos);
        }

        @Override
        public Node copy() {
            ParenGroupNode clone = new ParenGroupNode(this.getStartPos());
            this.copyNodes(clone);
            return clone;
        }

        @Override
        void build(StringBuilder builder) {
            builder.append('(');
            super.build(builder);
            builder.append(')');
        }
    }

    public static class EscapeNode
    extends CompositeNode {
        public EscapeNode(int startPos) {
            super(startPos);
        }

        @Override
        public Node copy() {
            EscapeNode clone = new EscapeNode(this.getStartPos());
            this.copyNodes(clone);
            return clone;
        }

        @Override
        void build(StringBuilder builder) {
            builder.append('{');
            super.build(builder);
            builder.append('}');
        }
    }

    public static class StatementNode
    extends CompositeNode {
        public StatementNode(int startPos) {
            super(startPos);
        }

        @Override
        public Node copy() {
            StatementNode clone = new StatementNode(this.getStartPos());
            this.copyNodes(clone);
            return clone;
        }
    }

    public static class MultiStatementNode
    extends CompositeNode {
        public MultiStatementNode(int startPos) {
            super(startPos);
        }

        public MultiStatementNode(List<Node> nodes, int startPos) {
            super(nodes, startPos);
        }

        @Override
        public Node copy() {
            MultiStatementNode clone = new MultiStatementNode(this.getStartPos());
            this.copyNodes(clone);
            return clone;
        }

        @Override
        void build(StringBuilder builder) {
            Iterator<Node> nodeIter = this.iterator();
            while (nodeIter.hasNext()) {
                nodeIter.next().build(builder);
                if (!nodeIter.hasNext()) continue;
                builder.append(';');
            }
        }
    }

    public static class CompositeNode
    extends Node {
        protected List<Node> nodes = new ArrayList<Node>();

        public CompositeNode(int startPos) {
            super(startPos, -1);
        }

        public CompositeNode(List<Node> nodes, int startPos) {
            super(startPos, -1);
            this.nodes = nodes;
        }

        @Override
        public Node copy() {
            CompositeNode clone = new CompositeNode(this.getStartPos());
            this.copyNodes(clone);
            return clone;
        }

        protected void copyNodes(CompositeNode newNode) {
            newNode.nodes = new ArrayList<Node>(this.nodes.size());
            for (Node node : this.nodes) {
                newNode.nodes.add(node.copy());
            }
        }

        @Override
        void build(StringBuilder builder) {
            for (Node node : this.nodes) {
                node.build(builder);
            }
        }

        int getNodeCount() {
            return this.nodes.size();
        }

        Node get(int idx) {
            return this.nodes.get(idx);
        }

        void set(int idx, Node node) {
            this.nodes.set(idx, node);
        }

        Iterator<Node> iterator() {
            return this.nodes.iterator();
        }

        List<Node> subList(int fromIndex) {
            return this.subList(fromIndex, this.nodes.size());
        }

        List<Node> subList(int fromIndex, int toIndex) {
            return this.nodes.subList(fromIndex, toIndex);
        }

        @Override
        public Node process(Processor processor, boolean recurse) throws SQLException {
            ListIterator<Node> nodeIter = this.nodes.listIterator();
            while (nodeIter.hasNext()) {
                Node res = recurse ? nodeIter.next().process(processor, recurse) : processor.process(nodeIter.next());
                if (res != null) {
                    nodeIter.set(res);
                    continue;
                }
                nodeIter.remove();
            }
            return processor.process(this);
        }

        void add(Node node) {
            this.nodes.add(node);
        }

        public boolean containsAll(Class<? extends Node> cls) {
            for (Node node : this.nodes) {
                if (cls.isInstance(node)) continue;
                return false;
            }
            return true;
        }

        public void trim() {
            if (this.nodes.isEmpty()) {
                return;
            }
            if (this.nodes.get(0) instanceof WhitespacePiece) {
                this.nodes.remove(0);
            }
            if (this.nodes.isEmpty()) {
                return;
            }
            if (this.nodes.get(this.nodes.size() - 1) instanceof WhitespacePiece) {
                this.nodes.remove(this.nodes.size() - 1);
            }
        }

        public Node getFirstNode() {
            if (this.nodes.isEmpty()) {
                return null;
            }
            return this.nodes.get(0);
        }

        public Node getLastNode() {
            if (this.nodes.isEmpty()) {
                return null;
            }
            return this.nodes.get(this.nodes.size() - 1);
        }
    }

    public static abstract class Node {
        private int startPos;
        private int endPos;

        public Node(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public Node copy() {
            return this;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public void setStartPos(int start) {
            this.startPos = start;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public void setEndPos(int end) {
            this.endPos = end;
        }

        abstract void build(StringBuilder var1);

        public Node process(Processor processor, boolean recurse) throws SQLException {
            return processor.process(this);
        }

        void removeAll(final Class<? extends Node> nodeType, boolean recurse) {
            try {
                this.process(new Processor(){

                    @Override
                    public Node process(Node node) throws SQLException {
                        if (nodeType.isInstance(node)) {
                            return null;
                        }
                        return node;
                    }
                }, recurse);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.build(sb);
            return sb.toString();
        }
    }

    public static interface Processor {
        public Node process(Node var1) throws SQLException;
    }
}

