/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.Command;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.ResultField;
import java.util.ArrayList;
import java.util.List;

public interface QueryCommand
extends Command {
    public void setQueryTimeout(long var1);

    public void setMaxRows(int var1);

    public void setMaxFieldLength(int var1);

    public List<ResultBatch> getResultBatches();

    public Status getStatus();

    public static class ResultBatch {
        private String command = null;
        private Long rowsAffected = null;
        private Long insertedOid = null;
        private List<ResultField> fields = null;
        private List<DataRow> results = null;

        public void setCommand(String v) {
            this.command = v;
        }

        public String getCommand() {
            return this.command;
        }

        public void setRowsAffected(Long v) {
            this.rowsAffected = v;
        }

        public Long getRowsAffected() {
            return this.rowsAffected;
        }

        public void setInsertedOid(Long v) {
            this.insertedOid = v;
        }

        public Long getInsertedOid() {
            return this.insertedOid;
        }

        public void setFields(List<ResultField> v) {
            this.fields = v;
        }

        public List<ResultField> getFields() {
            return this.fields;
        }

        public void addResult(DataRow v) {
            if (this.results == null) {
                this.results = new ArrayList<DataRow>();
            }
            this.results.add(v);
        }

        public void resetResults(boolean allowEmpty) {
            if (this.results != null) {
                for (DataRow dataRow : this.results) {
                    dataRow.release();
                }
            }
            this.results = allowEmpty && this.fields != null && !this.fields.isEmpty() ? new ArrayList() : null;
        }

        public List<DataRow> getResults() {
            return this.results;
        }

        public void release() {
            this.resetResults(false);
        }

        public void touch() {
            if (this.results != null) {
                for (DataRow row : this.results) {
                    row.touch();
                }
            }
        }

        public static List<ResultBatch> releaseResultBatches(List<ResultBatch> resultBatches) {
            if (resultBatches != null) {
                for (ResultBatch resultBatch : resultBatches) {
                    resultBatch.release();
                }
            }
            return null;
        }
    }

    public static enum Status {
        Completed,
        Suspended;

    }
}

